import {connect} from 'react-redux';
import {FamilyKiddishInput as KiddishInput} from './FamilyKiddishInput';
import {updateCurrentSlot} from '../../middlewares/actions/common';
import {setKiddishFieldError} from '../../actions';

const mapStateToProps = (
    {family: {currentSlot = {}, kiddishAvatars = [], kiddishFieldsErrors = {}} = {}, settings: {isTouch = false}},
    {field}
) => ({
    value: currentSlot[field] || '',
    isTouch,
    kiddishAvatars,
    error: kiddishFieldsErrors[field] || ''
});

const mapDispatchToProps = {updateKiddish: updateCurrentSlot, setKiddishFieldError};

export const FamilyKiddishInput = connect(mapStateToProps, mapDispatchToProps)(KiddishInput);
