import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {PAGE_SELECTOR_TYPES} from '../../const';

import './FamilyLayout.styl';

const b = cn('FamilyLayout');
const dataT = 'family:layout';

export class FamilyLayout extends React.Component {
    renderContent = () => {
        const {children, isCard, isNotFixedWidthCard} = this.props;

        if (isCard) {
            return <div className={b('card', {isNotFixedWidthCard})}>{children}</div>;
        }

        return children;
    };
    onBackButtonClick = () => {
        const {goToMainPage, onBackButtonClick} = this.props;

        onBackButtonClick ? onBackButtonClick() : goToMainPage();
    };
    render() {
        const {
            curPageSelector,
            isWhiteBgMobile,
            isCentered,
            isCard,
            isNewLayout,
            isCrossBackButton,
            hideBackButton,
            smallSidePadding,
            mediumMaxWidthOnTouch,
            negativeMarginTop,
            hasBackButtonMarginOnTouch
        } = this.props;
        const isArrowIcon = !isCrossBackButton;

        return (
            <div
                className={b({
                    isCard,
                    isWhiteBgMobile,
                    isCentered,
                    isNewLayout,
                    isFlex: true,
                    selector: curPageSelector,
                    smallSidePadding,
                    mediumMaxWidthOnTouch,
                    negativeMarginTop
                })}
                data-t={dataT}
            >
                <div className={b('wrapper', {isFlex: true, mediumMaxWidthOnTouch})}>
                    {curPageSelector !== PAGE_SELECTOR_TYPES.MODAL && !hideBackButton && (
                        <button
                            data-t={`${dataT}:back`}
                            className={b('backButton', {
                                isArrowIcon,
                                isCrossBackButton,
                                hasBackButtonMarginOnTouch,
                                marginLeft: smallSidePadding
                            })}
                            onClick={this.onBackButtonClick}
                        >
                            <div
                                className={b('backButtonIcon', {
                                    isArrowIcon,
                                    isCrossBackButton
                                })}
                            />
                        </button>
                    )}
                    {this.renderContent()}
                </div>
            </div>
        );
    }
}

FamilyLayout.propTypes = {
    isGreyBg: PropTypes.bool,
    isWhiteBgMobile: PropTypes.bool,
    isCentered: PropTypes.bool,
    isCard: PropTypes.bool,
    className: PropTypes.string,
    curPageSelector: PropTypes.string,
    onBackButtonClick: PropTypes.func,
    goToMainPage: PropTypes.func,
    isNewLayout: PropTypes.bool,
    children: PropTypes.node,
    isCrossBackButton: PropTypes.bool,
    hideBackButton: PropTypes.bool,
    smallSidePadding: PropTypes.bool,
    isNotFixedWidthCard: PropTypes.bool,
    mediumMaxWidthOnTouch: PropTypes.bool,
    negativeMarginTop: PropTypes.bool,
    hasBackButtonMarginOnTouch: PropTypes.bool
};
