import {connect} from 'react-redux';
import {FamilyLayout as Layout} from './FamilyLayout';
import {goToMainPage} from '../../middlewares/routing';
import {withPageSelectorContext} from '../../page-selectors/context';

const mapStateToProps = (state) => {
    const {settings: {isNewLayout} = {}, family: {isCrossBackButton = false} = {}} = state;

    return {isNewLayout, isCrossBackButton};
};
const mapDispatchToProps = {goToMainPage};

export const FamilyLayout = connect(mapStateToProps, mapDispatchToProps)(withPageSelectorContext(Layout));
