import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {FamilyUniversalTile} from '../FamilyUniversalTile';
import {FamilyWarning} from '../FamilyWarning';
import {PAGES} from '../../const';
import './FamilyMainChildishBlock.styl';

const b = cn('FamilyMainChildishBlock');
const dataT = 'family:childish-main-block';

const getWarningText = (hasPhone, havePassword, hasLogin) => {
    if (!hasLogin && !hasPhone && !havePassword) {
        return i18n('Family.childish-main-block.warning.login.phone.password');
    }
    if (!hasLogin && !havePassword) {
        return i18n('Family.childish-main-block.warning.login.password');
    }
    if (!hasPhone) {
        return i18n('Family.childish-main-block.warning.phone');
    }
};

export class FamilyMainChildishBlock extends React.Component {
    goToKiddishLanding = () => {
        const {goToPage} = this.props;

        goToPage(PAGES.childishLanding);
    };

    render() {
        const {
            isTouch,
            knowMoreLink,
            registrationChildLink,
            hasPhone,
            havePassword,
            hasLogin,
            fromChildishRegLanding
        } = this.props;
        const warningText = getWarningText(hasPhone, havePassword, hasLogin);

        return (
            <div className={b({isTouch})} data-t={dataT}>
                <div className={b('wrapper')}>
                    <h2 className={b('title')}>{i18n('Family.slots-group.title.childish')}</h2>

                    <div className={b('description')}>
                        {i18n('Family.childish-main-block.description')}&nbsp;
                        <a
                            href={knowMoreLink}
                            className={b('knowMoreLink', {isTouch})}
                            data-t={`${dataT}:know-more-link`}
                        >
                            {i18n('Family.kiddish.know-more-link')}
                        </a>
                    </div>

                    {warningText && (
                        <div className={b('warning')}>
                            <FamilyWarning text={warningText} icon='shield' />
                        </div>
                    )}

                    <div className={b('tile', {isTouch})}>
                        <FamilyUniversalTile
                            type={fromChildishRegLanding ? 'link' : 'button'}
                            iconLeft='addKiddish'
                            href={fromChildishRegLanding ? registrationChildLink : null}
                            onClick={fromChildishRegLanding ? undefined : this.goToKiddishLanding}
                            title={i18n('Family.childish-main-block.tile')}
                            iconRight='arrowRight'
                            backgroundColor={isTouch ? '' : 'tintSuperLight'}
                            backgroundHoverColor={isTouch ? '' : 'tintLight'}
                        />
                    </div>
                </div>
            </div>
        );
    }
}

FamilyMainChildishBlock.propTypes = {
    hasPhone: PropTypes.bool,
    havePassword: PropTypes.bool,
    hasLogin: PropTypes.bool,
    isTouch: PropTypes.bool,
    registrationChildLink: PropTypes.string,
    knowMoreLink: PropTypes.string,
    fromChildishRegLanding: PropTypes.bool,
    goToPage: PropTypes.func
};
