import {connect} from 'react-redux';
import {FamilyMainChildishBlock as Block} from './FamilyMainChildishBlock';
import {goToPage} from '../../middlewares/routing';

const mapStateToProps = ({
    settings: {help: {kiddish} = {}, tld, passportLinks = {}},
    person: {hasPhone = false, havePassword = false} = {},
    header: {defaultAccount: {login = ''} = {}} = {},
    common: {neoPhonishPrefix = ''} = {},
    family: {fromChildishRegLanding = false}
} = {}) => ({
    knowMoreLink: kiddish.replace('%tld%', tld),
    registrationChildLink: passportLinks.registrationChild,
    hasPhone,
    havePassword,
    hasLogin: typeof login === 'string' && !login.startsWith(neoPhonishPrefix),
    fromChildishRegLanding
});

const mapDispatchToProps = {goToPage};

export const FamilyMainChildishBlock = connect(mapStateToProps, mapDispatchToProps)(Block);
