import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {FamilyUniversalTile} from '../FamilyUniversalTile';
import './FamilyMainKiddishBlock.styl';

const b = cn('FamilyMainKiddishBlock');
const dataT = 'family:kiddish-main-block';

export class FamilyMainKiddishBlock extends React.Component {
    constructor(props) {
        super(props);

        this.state = {
            kiddishNames: this.getKiddishNames(props.slots)
        };
    }

    getKiddishNames = (slots) =>
        slots
            .reduce((acc, slot) => {
                !slot.isEmpty && acc.push(slot.name);

                return acc;
            }, [])
            .join(', ');

    goToKiddishPage = () => {
        const {goToKiddishPage} = this.props;

        goToKiddishPage({withHistory: true});
    };

    render() {
        const {kiddishNames} = this.state;
        const {slots, isTouch, kiddishKnowMoreLink} = this.props;

        const isEmpty = slots.length === 1 && slots[0].isEmpty;
        const isMultiAvatar = slots.length > 2;

        return (
            <div className={b({isTouch})} data-t={dataT}>
                <div className={b('wrapper')}>
                    <h2 className={b('title')}>{i18n('Family.slots-group.title.kiddish')}</h2>
                    {isEmpty && (
                        <div className={b('description')}>
                            {i18n('Family.kiddish-main.empty.description')}&nbsp;
                            <a
                                href={kiddishKnowMoreLink}
                                className={b('knowMoreLink', {isTouch})}
                                data-t={`${dataT}:know-more-link`}
                            >
                                {i18n('Family.kiddish.know-more-link')}
                            </a>
                        </div>
                    )}
                    <div className={b('tile', {isTouch})}>
                        <FamilyUniversalTile
                            type='button'
                            iconLeft={isEmpty && 'addKiddish'}
                            avatarLeft={!isEmpty && slots[0]}
                            isMultiAvatar={isMultiAvatar}
                            avatarSize='xs'
                            avatarNoPlus={true}
                            slots={isMultiAvatar && slots}
                            onClick={this.goToKiddishPage}
                            title={isEmpty ? i18n('Family.kiddish.empty-slot') : kiddishNames}
                            iconRight='arrowRight'
                            dataT={isEmpty ? `${dataT}:button-empty` : `${dataT}:button-has-kiddish`}
                            backgroundColor={isTouch ? '' : 'tintSuperLight'}
                            backgroundHoverColor={isTouch ? '' : 'tintLight'}
                            titleEllipsisOverflow={true}
                        />
                    </div>
                </div>
            </div>
        );
    }
}

FamilyMainKiddishBlock.propTypes = {
    slots: PropTypes.array.isRequired,
    goToKiddishPage: PropTypes.func.isRequired,
    isTouch: PropTypes.bool,
    kiddishKnowMoreLink: PropTypes.string
};
