import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {getCookie} from '@blocks/utils';
import './FamilyNotification.styl';

const b = cn('FamilyNotification');

export class FamilyNotification extends React.PureComponent {
    componentWillUnmount() {
        clearTimeout(this.timerId);
        this.closeWarning();
    }

    componentDidUpdate(prevProps) {
        const {isVisible, theme, isTesting} = this.props;
        const time = (isTesting && Number(getCookie('DEBUG_FAMILY_NOTIFICATION_TIME'))) || 3500;

        if (!prevProps.isVisible && isVisible && theme !== 'link') {
            this.timerId = setTimeout(() => this.closeWarning(), time);
        }
    }

    closeWarning = () => {
        this.props.toggleFamilyNotification({
            isVisible: false,
            iconType: '',
            text: ''
        });
    };

    render() {
        const {isVisible, theme = 'default', text, iconType} = this.props;

        if (isVisible) {
            return (
                <div className={b('wrap')}>
                    <div className={b({theme})} role='alert'>
                        {iconType && <span aria-hidden='true' className={b('icon', {type: iconType})} />}
                        <span className={b('text')} dangerouslySetInnerHTML={{__html: text}} />
                        {theme === 'link' && (
                            <button
                                className={b('close')}
                                aria-label={i18n('Frontend.close')}
                                onClick={this.closeWarning}
                            />
                        )}
                    </div>
                </div>
            );
        }

        return null;
    }
}

FamilyNotification.propTypes = {
    isVisible: PropTypes.bool,
    isTesting: PropTypes.bool,
    text: PropTypes.string,
    iconType: PropTypes.string,
    theme: PropTypes.string,
    toggleFamilyNotification: PropTypes.func.isRequired
};
