import {connect} from 'react-redux';
import {FamilyNotification as NotificationComponent} from './FamilyNotification';
import {toggleFamilyNotification} from '@blocks/morda/new/family/actions';

const mapStateToProps = (state = {}) => {
    const {family: {notification = {}} = {}, settings: {env: {type: envType} = {}} = {}} = state;
    const {isVisible, text, iconType, theme} = notification;

    return {
        isTesting: ['development', 'testing'].includes(envType),
        isVisible,
        text,
        iconType,
        theme: theme || 'default'
    };
};

const mapDispatchToProps = {
    toggleFamilyNotification
};

export const FamilyNotification = connect(mapStateToProps, mapDispatchToProps)(NotificationComponent);
