import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Tumbler} from '@components/Tumbler';
import {metrics} from '../../../utils/metrics';
import {addCurrencySymbol} from '../../../utils/currency';
import {LIMIT_MODES, PAY_SERVICES} from '../../../const';
import {FamilyUniversalTileList} from '../../FamilyUniversalTileList';
import {FamilyPayLimitsServices} from '../Services';

import './FamilyPayLimitsControls.styl';

const b = cn('FamilyPayLimitsControls');

export class FamilyPayLimitsControls extends React.Component {
    state = {isServicesOpened: false, isToggleOn: true};
    onServicesClick = () => {
        const {isEnabled} = this.props;
        const {isServicesOpened} = this.state;

        if (isEnabled) {
            metrics.sendPay(['Нажатие на сервисы', isServicesOpened ? 'Закрытие' : 'Открытие']);
            this.setState({isServicesOpened: !isServicesOpened});
        }
    };
    onAllowAllServicesClick = () => {
        const {
            isEnabled,
            allowAllServices,
            updatePayLimitForm,
            placeId,
            hasPayTankerExp,
            hasPayAfishaExp,
            hasPayHealthExp
        } = this.props;
        const allAllowedServices = Object.keys(PAY_SERVICES).filter(
            (service) =>
                (service !== 'tanker' || hasPayTankerExp) &&
                (service !== 'afisha' || hasPayAfishaExp) &&
                (service !== 'health' || hasPayHealthExp)
        );

        if (isEnabled) {
            metrics.sendPay(['Нажатие на разрешить все сервисы', allowAllServices ? 'Запрет' : 'Разрешение']);
            updatePayLimitForm({
                placeId,
                allowAllServices: !allowAllServices,
                allowedServices: allowAllServices ? allAllowedServices : []
            });
        }
    };
    onBalanceClick = () => {
        const {
            placeId,
            postFillBalance,
            loading,
            isEnabled,
            updatePayLimitCurrentSlotBalance,
            fetchFamily
        } = this.props;

        metrics.sendPay(['Нажатие на кнопку Пополнить баланс']);

        if (!loading && isEnabled) {
            postFillBalance(placeId).done(() => {
                updatePayLimitCurrentSlotBalance();
                fetchFamily();
            });
        }
    };
    onToggleClick = () => {
        const {placeId, isEnabled, updatePayLimitForm} = this.props;

        metrics.sendPay(['Изменение статуса карты у участника', isEnabled ? 'Заблокирована' : 'Разрешена']);

        updatePayLimitForm({placeId, isEnabled: !isEnabled});
    };
    render() {
        const {
            balance,
            maxBalance,
            language,
            currency,
            limitMode,
            isEnabled,
            allowAllServices,
            hideServices
        } = this.props;
        const isServicesOpened = this.state.isServicesOpened && !allowAllServices && isEnabled;
        const isMaxBalance = maxBalance === balance;

        return (
            <div className={b({opened: isServicesOpened})}>
                <div className={b('tiles')}>
                    <FamilyUniversalTileList
                        tiles={[
                            {
                                type: 'block',
                                title: isEnabled
                                    ? i18n('Family.payLimitsControls.toggle.title.off')
                                    : i18n('Family.payLimitsControls.toggle.title.on'),
                                description: isEnabled
                                    ? i18n('Family.payLimitsControls.toggle.description.off')
                                    : i18n('Family.payLimitsControls.toggle.description.on'),
                                iconLeft: isEnabled ? 'card2' : 'ban',
                                iconLeftBg: true,
                                iconRightComponent: <Tumbler size='m' checked={isEnabled} />,
                                onClick: this.onToggleClick,
                                dataT: 'pay-limits-controls:limit-toggle'
                            },
                            limitMode !== LIMIT_MODES.NOLIMIT && {
                                type: isMaxBalance ? 'block' : 'button',
                                isDisabled: !isEnabled,
                                title: i18n('Family.payLimitsControls.balance.title').replace(
                                    '%s',
                                    addCurrencySymbol(balance, currency, language)
                                ),
                                description: isMaxBalance
                                    ? i18n('Family.payLimitsControls.balance.description.max')
                                    : i18n('Family.payLimitsControls.balance.description').replace(
                                          '%s',
                                          addCurrencySymbol(maxBalance, currency, language)
                                      ),
                                iconLeft: 'download',
                                iconLeftBg: true,
                                onClick: isMaxBalance ? null : this.onBalanceClick,
                                dataT: 'pay-limits-controls:balance-control'
                            },
                            !hideServices && {
                                type: 'block',
                                title: i18n('Family.payLimitsControls.allowAllServices.title'),
                                isDisabled: !isEnabled,
                                iconLeft: 'ya',
                                iconLeftBg: true,
                                iconRightComponent: <Tumbler size='m' checked={allowAllServices} />,
                                onClick: this.onAllowAllServicesClick,
                                dataT: 'pay-limits-controls:allow-services-control'
                            },
                            !hideServices &&
                                !allowAllServices && {
                                    title: i18n('Family.payLimitsControls.services.title'),
                                    description: i18n('Family.payLimitsControls.services.description'),
                                    isDisabled: !isEnabled,
                                    iconLeft: '9points',
                                    iconLeftBg: true,
                                    iconRight: 'arrowBottom',
                                    iconRightRotate: isServicesOpened,
                                    onClick: this.onServicesClick,
                                    dataT: 'pay-limits-controls:services-control'
                                }
                        ]}
                    />
                </div>
                {!hideServices && (
                    <div className={b('services')}>
                        <FamilyPayLimitsServices opened={isServicesOpened && isEnabled} />
                    </div>
                )}
            </div>
        );
    }
}

FamilyPayLimitsControls.propTypes = {
    loading: PropTypes.bool,
    isEnabled: PropTypes.bool,
    allowAllServices: PropTypes.bool,
    allowedServices: PropTypes.array,
    postFillBalance: PropTypes.func,
    updatePayLimitForm: PropTypes.func,
    updatePayLimitCurrentSlotBalance: PropTypes.func,
    fetchFamily: PropTypes.func,
    limitMode: PropTypes.oneOf(Object.values(LIMIT_MODES)),
    currency: PropTypes.string,
    placeId: PropTypes.string,
    balance: PropTypes.string,
    maxBalance: PropTypes.string,
    language: PropTypes.string,
    hideServices: PropTypes.bool,
    hasPayTankerExp: PropTypes.bool,
    hasPayAfishaExp: PropTypes.bool,
    hasPayHealthExp: PropTypes.bool
};
