import {connect} from 'react-redux';
import {hasExp} from '@blocks/selectors';
import {FamilyPayLimitsControls as PayLimitsControls} from './FamilyPayLimitsControls';
import {fetchFamily} from '../../../middlewares/api/state';
import {postFillBalance} from '../../../middlewares/api/pay';
import {updatePayLimitForm, updatePayLimitCurrentSlotBalance} from '../../../middlewares/actions/pay';
import {CURRENCIES} from '../../../const';

const mapStateToProps = ({
    common = {},
    settings: {language} = {},
    family: {
        currentSlotLimitInfo: {
            currency = CURRENCIES.RUB,
            limit: {limitMode, value: maxBalance = 0} = {},
            balance = 0,
            placeId
        } = {},
        currentSlotFormLimitInfo: {isEnabled, allowAllServices = false, allowedServices = []} = {},
        hideServices = false
    } = {}
} = {}) => ({
    language,
    balance,
    maxBalance,
    placeId,
    currency,
    isEnabled,
    allowAllServices,
    allowedServices,
    limitMode,
    hideServices,
    hasPayTankerExp: hasExp({common}, 'profile-family-pay-tanker-exp'),
    hasPayAfishaExp: hasExp({common}, 'profile-family-pay-afisha-exp'),
    hasPayHealthExp: hasExp({common}, 'profile-family-pay-health-exp')
});

const mapDispatchToProps = {postFillBalance, updatePayLimitForm, updatePayLimitCurrentSlotBalance, fetchFamily};

export const FamilyPayLimitsControls = connect(mapStateToProps, mapDispatchToProps)(PayLimitsControls);
