import {connect} from 'react-redux';
import {FamilyPayLimitsInput as PayLimitsInput} from './FamilyPayLimitsInput';
import {goToMainPage} from '../../../middlewares/routing';
import {updatePayLimitForm} from '../../../middlewares/actions/pay';
import {CURRENCIES, LIMIT_MODES} from '../../../const';

const mapStateToProps = ({
    family: {
        currentSlot,
        currentSlotLimitInfo: {currency = CURRENCIES.RUB} = {},
        currentSlotFormLimitInfo: {
            currency: payFormLimitCurrency,
            limit: {limitMode = LIMIT_MODES.DAY, value = 0} = {},
            placeId,
            isEnabled
        } = {},
        pay: {defaultValue} = {}
    } = {}
}) => ({limitMode, value, placeId, currency, isEnabled, currentSlot, payFormLimitCurrency, defaultValue});

const mapDispatchToProps = {goToMainPage, updatePayLimitForm};

export const FamilyPayLimitsInput = connect(mapStateToProps, mapDispatchToProps)(PayLimitsInput);
