import {connect} from 'react-redux';
import {hasExp} from '@blocks/selectors';
import {FamilyPayLimitsServices as PayLimitsServices} from './FamilyPayLimitsServices';
import {updatePayLimitForm} from '../../../middlewares/actions/pay';

const mapStateToProps = (state, {yourServices = false}) => {
    const {family: {currentSlotFormLimitInfo = {}, yourSlotLimitInfo = {}} = {}} = state;
    const {allowedServices = [], placeId, allowAllServices} = yourServices
        ? yourSlotLimitInfo
        : currentSlotFormLimitInfo;
    const hasPayTankerExp = hasExp(state, 'profile-family-pay-tanker-exp');
    const hasPayAfishaExp = hasExp(state, 'profile-family-pay-afisha-exp');
    const hasPayHealthExp = hasExp(state, 'profile-family-pay-health-exp');
    const hasPayHelpExp = hasExp(state, 'profile-family-pay-help-exp');

    return {
        allowedServices,
        allowAllServices,
        placeId,
        hasPayTankerExp,
        hasPayAfishaExp,
        hasPayHealthExp,
        hasPayHelpExp
    };
};

const mapDispatchToProps = {updatePayLimitForm};

export const FamilyPayLimitsServices = connect(mapStateToProps, mapDispatchToProps)(PayLimitsServices);
