import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {FamilyAvatar} from '../../FamilyAvatar';
import {getSlotSubtitle} from '../../../utils/getSlotSubtitle';
import './FamilyPayLimitsUsers.styl';

const b = cn('FamilyPayLimitsUsers');

export class FamilyPayLimitsUsers extends React.Component {
    componentDidMount() {
        const {setCurrentSlot, slots = [], isAm, hasLimitPreFilled, hasPrefilledMember, currentSlot = {}} = this.props;
        const {isPrefilledForLimitPage = false, ...newCurrentSlot} = currentSlot;

        if (isPrefilledForLimitPage) {
            return setCurrentSlot(newCurrentSlot);
        }

        if (!(isAm || hasLimitPreFilled || hasPrefilledMember)) {
            setCurrentSlot(slots[0]);
        }
    }
    onSlotClick = (e) => {
        const {slots = [], goToInvitePage, setCurrentSlot} = this.props;
        const index = Number(e.currentTarget.dataset.index);
        const slot = slots[index] || {};

        return slot && slot.isUser ? setCurrentSlot(slot) : goToInvitePage();
    };
    render() {
        const {slots = [], currentSlot = {}, currentSlotUserIndex = 0, hideFormLimitsUsers = false} = this.props;

        if (hideFormLimitsUsers) {
            return <div className={b({onlyName: hideFormLimitsUsers})}>{currentSlot.name}</div>;
        }

        // Админа, который первый в списке слотов, не считаем.
        const currentIndex = currentSlotUserIndex === 0 ? 0 : currentSlotUserIndex - 1;

        return (
            <div className={b()}>
                <div className={b('users', {current: String(currentIndex)})}>
                    {slots.map((slot, index) => (
                        <div
                            className={b('user', {current: index === currentIndex})}
                            key={index}
                            data-index={index}
                            onClick={this.onSlotClick}
                        >
                            <FamilyAvatar slot={slot} size='s' noPlus={true} />
                        </div>
                    ))}
                </div>
                <div className={b('name')}>{currentSlot.name}</div>
                <div className={b('subtitle')}>{getSlotSubtitle(currentSlot)}</div>
            </div>
        );
    }
}

FamilyPayLimitsUsers.propTypes = {
    slots: PropTypes.array,
    currentSlot: PropTypes.object,
    currentSlotUserIndex: PropTypes.number,
    isAm: PropTypes.bool,
    goToInvitePage: PropTypes.func,
    setCurrentSlot: PropTypes.func,
    hideFormLimitsUsers: PropTypes.bool,
    hasLimitPreFilled: PropTypes.bool,
    hasPrefilledMember: PropTypes.bool
};
