import {connect} from 'react-redux';
import {FamilyPayLimitsUsers as PayLimitsUsers} from './FamilyPayLimitsUsers';
import {goToInvitePage} from '../../../middlewares/routing';
import {setCurrentSlot} from '../../../middlewares/actions/common';

const mapStateToProps = ({
    family: {
        memberSlots = [],
        membersWithoutAdminSlots = [],
        membersWithoutAdminAndEmptySlots = [],
        inviteSlots = [],
        slots = [],
        isLimitsPage = false,
        currentSlot = {},
        currentSlotUserIndex = 0,
        hideFormLimitsUsers = false,
        hasLimitPreFilled = false,
        hasPrefilledMember = false
    } = {},
    am: {isAm = false} = {}
} = {}) => {
    const isNoEmptySlot = slots.length === memberSlots.length + inviteSlots.length;

    return {
        slots: isLimitsPage || isNoEmptySlot ? membersWithoutAdminSlots : membersWithoutAdminAndEmptySlots,
        isAm,
        currentSlot,
        currentSlotUserIndex,
        hideFormLimitsUsers,
        hasLimitPreFilled,
        hasPrefilledMember
    };
};

const mapDispatchToProps = {goToInvitePage, setCurrentSlot};

export const FamilyPayLimitsUsers = connect(mapStateToProps, mapDispatchToProps)(PayLimitsUsers);
