import {connect} from 'react-redux';
import {FamilyPayLimits as PayLimits} from './FamilyPayLimits';
import {goToMainPage} from '../../middlewares/routing';
import {fetchFamily} from '../../middlewares/api/state';
import {postUsersLimits} from '../../middlewares/api/pay';
import {setPaySettingsOpenedState, resetPayLimitsForm} from '../../middlewares/actions/pay';
import {setCurrentSlot} from '../../middlewares/actions/common';

const mapDispatchToProps = {
    goToMainPage,
    fetchFamily,
    postUsersLimits,
    setPaySettingsOpenedState,
    resetPayLimitsForm,
    setCurrentSlot
};
const mapStateToProps = ({
    family: {
        loading,
        isLimitsPage = false,
        currentSlot,
        currentSlotFormLimitInfo,
        origin,
        limitsPageBottomPadding,
        notRedirectWithoutRetpath,
        hideLimitsPageBackButton,
        hasLimitsError,
        limitsError,
        isWebview = false
    } = {},
    am: {isAm = false, finishOkUrl, finishCancelUrl, finishErrorUrl} = {},
    common: {retpath},
    settings: {isTouch = false}
}) => ({
    loading,
    isLimitsPage,
    isAm,
    isTouch,
    finishOkUrl,
    finishCancelUrl,
    finishErrorUrl,
    retpath,
    currentSlot,
    currentSlotFormLimitInfo,
    origin,
    limitsPageBottomPadding,
    notRedirectWithoutRetpath,
    hideLimitsPageBackButton,
    hasLimitsError,
    limitsError,
    isWebview
});

export const FamilyPayLimits = connect(mapStateToProps, mapDispatchToProps)(PayLimits);
