import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {FamilyPayDisableIcon} from '../../../icons/FamilyPayDisableIcon';
import {FamilyPayNoLimitIcon} from '../../../icons/FamilyPayNoLimitIcon';
import {LIMIT_MODES} from '../../../const';
import {addCurrencySymbol} from '../../../utils/currency';
import './FamilyPaySettingsBanner.styl';

const b = cn('FamilyPaySettingsBanner');

const TEXTS = {
    [LIMIT_MODES.DAY]: i18n('Family.paySettings.yourLimit.description.day'),
    [LIMIT_MODES.WEEK]: i18n('Family.paySettings.yourLimit.description.week'),
    [LIMIT_MODES.MONTH]: i18n('Family.paySettings.yourLimit.description.month'),
    [LIMIT_MODES.TOTAL]: i18n('Family.paySettings.yourLimit.description.total'),
    [LIMIT_MODES.NOLIMIT]: i18n('Family.paySettings.yourLimit.description.nolimit')
};

const BALANCE_TO_DECREASE_FONT = 9999;

export const FamilyPaySettingsBanner = ({isCardActualyEnabled, balance, language, limitMode, limitValue, currency}) => {
    return (
        <div className={b()} data-t='family:pay-settings-banner'>
            {isCardActualyEnabled ? (
                <>
                    <div
                        className={b('title', {
                            smallerFontSize: balance > BALANCE_TO_DECREASE_FONT,
                            icon: limitMode === LIMIT_MODES.NOLIMIT
                        })}
                    >
                        {limitMode === LIMIT_MODES.NOLIMIT ? (
                            <FamilyPayNoLimitIcon />
                        ) : (
                            addCurrencySymbol(balance, currency, language)
                        )}
                    </div>
                    <div className={b('subtitle')}>
                        {TEXTS[limitMode].replace('%limit', addCurrencySymbol(limitValue, currency, language))}
                    </div>
                </>
            ) : (
                <>
                    <div className={b('title', {icon: true})}>
                        <FamilyPayDisableIcon />
                    </div>
                    <div className={b('subtitle')}>{i18n('Family.paySettings.yourLimit.description.disabled')}</div>
                </>
            )}
        </div>
    );
};

FamilyPaySettingsBanner.propTypes = {
    isCardActualyEnabled: PropTypes.bool,
    balance: PropTypes.number,
    limitValue: PropTypes.number,
    language: PropTypes.string,
    limitMode: PropTypes.string,
    currency: PropTypes.string
};
