import {connect} from 'react-redux';
import {CURRENCIES} from '../../../const';
import {FamilyPaySettingsBanner as Banner} from './FamilyPaySettingsBanner';

const mapStateToProps = (
    {settings: {language} = {}, family: {pay: {usersInfoByPlaceId = {}} = {}}},
    {slot: {placeId} = {}}
) => {
    const {
        balance = 0,
        currency = CURRENCIES.RUB,
        limit: {limitMode, value: limitValue} = {},
        isCardActualyEnabled
    } = usersInfoByPlaceId[placeId];

    return {language, balance, limitMode, limitValue, currency, isCardActualyEnabled};
};

export const FamilyPaySettingsBanner = connect(mapStateToProps)(Banner);
