import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {FamilyUniversalTileList} from '../FamilyUniversalTileList';
import {FamilyPayLimitsServices} from '../FamilyPayLimits/Services';
import {FamilyWebviewHeader} from '../FamilyWebviewHeader';
import {LIMIT_MODES, PAGES} from '../../const';
import {addCurrencySymbol} from '../../utils/currency';
import {FamilyPaySettingsBanner} from './Banner';
import './FamilyPaySettings.styl';

const b = cn('FamilyPaySettings');

const TEXTS = {
    [LIMIT_MODES.DAY]: i18n('Family.paySettings.yourLimit.description.day'),
    [LIMIT_MODES.WEEK]: i18n('Family.paySettings.yourLimit.description.week'),
    [LIMIT_MODES.MONTH]: i18n('Family.paySettings.yourLimit.description.month'),
    [LIMIT_MODES.TOTAL]: i18n('Family.paySettings.yourLimit.description.total'),
    [LIMIT_MODES.NOLIMIT]: i18n('Family.paySettings.yourLimit.description.nolimit')
};
const dataTPrefix = 'family:pay-settings';

export class FamilyPaySettings extends React.Component {
    state = {isServicesOpened: false};
    onClickBase = (page) => {
        const {setPaySettingsOpenedState, goToPage} = this.props;

        setPaySettingsOpenedState(false);
        goToPage(page);
    };
    onUnbindClick = () => this.onClickBase(PAGES.payUnbind);
    onLimitsClick = () => this.onClickBase(PAGES.payLimits);
    onInviteClick = () => this.props.goToInvitePage();
    onServicesClick = () => this.setState({isServicesOpened: !this.state.isServicesOpened});
    onChangeCardClick = () => this.onClickBase(PAGES.payCards);
    onCloseButtonClick = () => {
        const {finishCancelUrl} = this.props;

        window.location.href = finishCancelUrl;
    };
    render() {
        const {
            isAdminAccess,
            adminSlot = {},
            yourSlot = {},
            limit,
            limitMode,
            language,
            currency,
            isAm,
            isShowInviteTile,
            isCardActualyEnabled,
            isLimitsPage,
            hideServices,
            hideFamilyInvite
        } = this.props;
        const {isServicesOpened} = this.state;
        const showHeader = isAm && isLimitsPage;
        const isShowLimitsTile = !(isShowInviteTile && hideFamilyInvite);

        return (
            <div className={b({isAm})} data-t={dataTPrefix}>
                {showHeader && <FamilyWebviewHeader />}
                {!isAdminAccess && (
                    <div className={b('banner')}>
                        <FamilyPaySettingsBanner slot={yourSlot} />
                    </div>
                )}
                <FamilyUniversalTileList
                    tiles={
                        isAdminAccess
                            ? [
                                  isShowLimitsTile && {
                                      type: 'button',
                                      title: isShowInviteTile
                                          ? i18n('Family.paySettings.invite.title')
                                          : i18n('Family.paySettings.limits.title.v2'),
                                      iconLeft: 'download',
                                      iconLeftBg: true,
                                      iconRight: 'arrowRight',
                                      iconRightPosition: isShowInviteTile ? 'center' : 'top',
                                      dataT: `${dataTPrefix}:admin:${isShowInviteTile ? 'invite' : 'limits'}`,
                                      onClick: isShowInviteTile ? this.onInviteClick : this.onLimitsClick
                                  },
                                  {
                                      type: 'block',
                                      title: i18n('Family.paySettings.changeCard.title'),
                                      iconLeft: 'card2',
                                      iconLeftBg: true,
                                      iconRight: 'arrowRight',
                                      iconRightPosition: 'center',
                                      dataT: `${dataTPrefix}:admin:change`,
                                      onClick: this.onChangeCardClick
                                  },
                                  {
                                      type: 'block',
                                      title: i18n('Family.paySettings.turnOff.title.v2'),
                                      iconLeft: 'ban',
                                      iconLeftBg: true,
                                      iconRight: 'arrowRight',
                                      iconRightPosition: 'center',
                                      dataT: `${dataTPrefix}:admin:turn-off`,
                                      onClick: this.onUnbindClick
                                  }
                              ]
                            : isCardActualyEnabled
                            ? [
                                  {
                                      type: 'block',
                                      label: i18n('Family.paySettings.owner.title'),
                                      title: adminSlot.name,
                                      dataT: `${dataTPrefix}:member:enabled:owner`,
                                      avatarLeft: adminSlot,
                                      avatarSize: 'xs'
                                  },
                                  {
                                      type: 'block',
                                      label: i18n('Family.paySettings.yourLimit.title'),
                                      title: TEXTS[limitMode].replace(
                                          '%limit',
                                          addCurrencySymbol(limit, currency, language)
                                      ),
                                      dataT: `${dataTPrefix}:member:enabled:your-limit`,
                                      iconLeft: 'download',
                                      iconLeftBg: true
                                  },
                                  !hideServices && {
                                      type: 'button',
                                      label: i18n('Family.paySettings.yourServices.title'),
                                      title: isServicesOpened
                                          ? i18n('Family.paySettings.yourServices.desc.opened')
                                          : i18n('Family.paySettings.yourServices.desc.hided'),
                                      iconLeft: '9points',
                                      iconLeftBg: true,
                                      iconRight: 'arrowBottom',
                                      iconRightRotate: isServicesOpened,
                                      dataT: `${dataTPrefix}:member:enabled:your-services`,
                                      onClick: this.onServicesClick
                                  }
                              ]
                            : [
                                  {
                                      type: 'block',
                                      label: i18n('Family.paySettings.owner.title'),
                                      title: adminSlot.name,
                                      dataT: `${dataTPrefix}:member:disabled:owner`,
                                      avatarLeft: adminSlot,
                                      avatarSize: 'xs'
                                  }
                              ]
                    }
                />
                {!isAdminAccess && isCardActualyEnabled && !hideServices && (
                    <div className={b('services', {opened: isServicesOpened, isAm})}>
                        <FamilyPayLimitsServices
                            opened={isServicesOpened}
                            readOnly={true}
                            yourServices={true}
                            showDisclaimer={false}
                        />
                    </div>
                )}
            </div>
        );
    }
}

FamilyPaySettings.propTypes = {
    goToPage: PropTypes.func,
    goToInvitePage: PropTypes.func,
    setPaySettingsOpenedState: PropTypes.func,
    adminSlot: PropTypes.object,
    yourSlot: PropTypes.object,
    balance: PropTypes.number,
    limit: PropTypes.number,
    limitMode: PropTypes.string,
    currency: PropTypes.string,
    language: PropTypes.string,
    isAdminAccess: PropTypes.bool,
    noPadding: PropTypes.bool,
    showClose: PropTypes.bool,
    isAm: PropTypes.bool,
    isShowInviteTile: PropTypes.bool,
    isCardActualyEnabled: PropTypes.bool,
    finishCancelUrl: PropTypes.string,
    isLimitsPage: PropTypes.bool,
    hideServices: PropTypes.bool,
    hideFamilyInvite: PropTypes.bool
};
