import {connect} from 'react-redux';
import {FamilyPaySettings as PaySettings} from './FamilyPaySettings';
import {goToPage, goToInvitePage} from '../../middlewares/routing';
import {setPaySettingsOpenedState} from '../../middlewares/actions/pay';
import {CURRENCIES} from '../../const';

const mapStateToProps = ({
    family: {
        adminSlot = {},
        isAdminAccess = false,
        yourSlot = {},
        yourSlotLimitInfo: {
            currency = CURRENCIES.RUB,
            balance = 0,
            limit: {value: limit = 0, limitMode} = {},
            isCardActualyEnabled
        } = {},
        memberSlots = [],
        isLimitsPage = false,
        hideServices = false,
        hideFamilyInvite = false
    },
    settings: {language} = {},
    am: {isAm = false, finishCancelUrl} = {}
}) => ({
    limit,
    balance,
    limitMode,
    currency,
    language,
    isAdminAccess,
    adminSlot,
    yourSlot,
    finishCancelUrl,
    isAm,
    isShowInviteTile: memberSlots.length < 2,
    isCardActualyEnabled,
    isLimitsPage,
    hideServices,
    hideFamilyInvite
});

const mapDispatchToProps = {goToPage, goToInvitePage, setPaySettingsOpenedState};

export const FamilyPaySettings = connect(mapStateToProps, mapDispatchToProps)(PaySettings);
