import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import './FamilySlider.styl';

const b = cn('FamilySlider');

const PHOTO_WIDTH = 136;
const TICK_MAX_STEP = 9;
const TICK_TIMEOUT = 6;

export class FamilySlider extends React.Component {
    isInProcess = false;
    componentDidMount() {
        const {ages, value} = this.props;

        this.updateKiddishAndScroll(ages.find((age) => age === value) || ages[0], true);
    }
    scrollTo = (index, immediately = false) => {
        const child = this.contentElement.children[index];

        this.scrollFromTo(
            this.contentElement.scrollLeft,
            child.offsetLeft + (child.scrollWidth - this.contentElement.clientWidth) / 2,
            immediately
        );
    };
    scrollFromTo = (from, to, immediately = false) => {
        if (immediately) {
            this.contentElement.scrollLeft = to;
        }
        if (from !== parseInt(from) || to !== parseInt(to) || immediately) {
            return;
        }

        this.isInProcess = true;

        const diff = Math.abs(to - from);
        const sign = to === from ? 0 : to > from ? 1 : -1;
        const step = Math.min(1 + diff / PHOTO_WIDTH, TICK_MAX_STEP) * sign;

        let path = 0;

        const timeoutFunc = () =>
            setTimeout(() => {
                path += step;
                this.contentElement.scrollLeft = from + path;
                if (diff > Math.abs(path)) {
                    timeoutFunc();
                } else {
                    this.contentElement.scrollLeft = to;
                    this.isInProcess = false;
                }
            }, TICK_TIMEOUT);

        timeoutFunc();
    };
    setContentRef = (contentElement) => {
        this.contentElement = contentElement;
    };
    onValueClick = (e) => {
        if (e && e.target && !this.isInProcess) {
            this.updateKiddishAndScroll(Number(e.target.dataset.value), true);
        }
    };
    updateKiddishAndScroll = (age, immediately = false) => {
        const {updateKiddish, field, value} = this.props;

        if (age !== value || immediately) {
            this.scrollToAge(age, immediately);
            updateKiddish({[field]: age});
        }
    };
    scrollToAge = (age, immediately = false) => {
        const {ages, count} = this.props;

        this.scrollTo(Math.floor(count / 2) + ages.indexOf(age) * count, immediately);
    };
    render() {
        const {ages, count, value} = this.props;

        return (
            <div className={b()}>
                <div className={b('values', {noCurrent: !value && value !== 0})}>
                    {ages.map((age) => (
                        <div
                            className={b('value', {current: age === value})}
                            key={age}
                            data-value={age}
                            onClick={this.onValueClick}
                        >
                            {age}+
                        </div>
                    ))}
                </div>
                <div className={b('content')} ref={this.setContentRef}>
                    {ages
                        .reduce((acc, age) => {
                            for (let i = 0; i < count; i++) {
                                acc.push({age, index: i + 1});
                            }
                            return acc;
                        }, [])
                        .map(({age, index}, i) => (
                            <div className={b('photo', {age: age === 0 ? '0' : age, index})} key={i} />
                        ))}
                </div>
            </div>
        );
    }
}

FamilySlider.propTypes = {
    field: PropTypes.string,
    value: PropTypes.number,
    count: PropTypes.number,
    ages: PropTypes.arrayOf(PropTypes.number),
    updateKiddish: PropTypes.func
};
