import React from 'react';
import PropTypes from 'prop-types';
import {FamilyButton} from '../FamilyButton';
import {FamilyAvatar} from '../FamilyAvatar';
import {FamilyKiddishInfo} from '../FamilyKiddishInfo';
import {cn} from '@bem-react/classname';
import './FamilySlot.styl';

const b = cn('FamilySlot');
const dataTPrefix = 'family:slot';

export const FamilySlot = ({
    slot,
    type,
    index,
    groupType,
    isBig,
    isTouch,
    onClick,
    onEditKiddishClick,
    isPlus,
    buttons,
    name,
    subtitle,
    children
}) => {
    const {isEmpty, isYou, isStub} = slot;

    const dataT = groupType ? `${dataTPrefix}:${type}:${groupType}` : `${dataTPrefix}:${type}`;

    if (!slot) {
        return null;
    }

    return (
        <div
            className={b({
                isEmpty: isEmpty || isStub,
                isBig,
                isClickable: Boolean(onClick && !isBig),
                isTouch,
                isPlus,
                isHoverable: !isBig && !isTouch,
                type
            })}
            onClick={onClick}
            data-t={typeof index !== 'undefined' ? `${dataT}:${index}` : dataT}
        >
            {children || (
                <>
                    <FamilyAvatar slot={slot} size={isBig ? 'l' : 's'} isCentered={isBig} />
                    {isTouch && (
                        <div className={b('arrow')}>
                            <div className='p-return' />
                        </div>
                    )}
                    <div className={b('info', {isPlus})}>
                        <div className={b('name', {isYou})}>
                            {isYou ? (
                                <>
                                    <span className={b('youName')}>{name}</span>
                                    <span className={b('youMark')}>({i18n('Family.member.name.you')})</span>
                                </>
                            ) : (
                                name
                            )}
                        </div>
                        <div className={b('subtitle', {isPlus})}>{subtitle}</div>
                    </div>
                    {slot.isKiddish && isBig && (
                        <div className={b('kiddishInfo')}>
                            <FamilyKiddishInfo kiddish={slot} onEditKiddishClick={onEditKiddishClick} />
                        </div>
                    )}
                    {Boolean(buttons && buttons.length) && (
                        <div className={b('button')}>
                            {buttons.map((button, index) => (
                                <FamilyButton {...button} key={index} />
                            ))}
                        </div>
                    )}
                </>
            )}
        </div>
    );
};

FamilySlot.propTypes = {
    slot: PropTypes.object,
    type: PropTypes.string,
    index: PropTypes.number,
    buttons: PropTypes.arrayOf(
        PropTypes.shape({
            view: PropTypes.oneOf(['default', 'action']),
            text: PropTypes.string,
            onClick: PropTypes.func
        })
    ),
    name: PropTypes.string,
    groupType: PropTypes.string,
    subtitle: PropTypes.string,
    children: PropTypes.node,
    onClick: PropTypes.func,
    onEditKiddishClick: PropTypes.func,
    isBig: PropTypes.bool,
    isPlus: PropTypes.bool,
    isTouch: PropTypes.bool
};
