import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {FamilyMainKiddishBlock} from '../FamilyMainKiddishBlock';
import {FamilyMainChildishBlock} from '../FamilyMainChildishBlock';
import {FamilySlotsList} from '../FamilySlotsList';
import {SLOTS_GROUP_TYPES} from '../../const';
import './FamilySlotsGroup.styl';

const b = cn('FamilySlotsGroup');

export const FamilySlotsGroup = ({slots, type, isTouch}) => (
    <div className={b()} data-t={`family:slots-group:${type}`}>
        {type === SLOTS_GROUP_TYPES.MEMBER ? (
            <FamilySlotsList slots={slots} isTile={isTouch} />
        ) : type === SLOTS_GROUP_TYPES.KIDDISH ? (
            <FamilyMainKiddishBlock isTouch={isTouch} slots={slots} />
        ) : (
            <FamilyMainChildishBlock isTouch={isTouch} slots={slots} />
        )}
    </div>
);

FamilySlotsGroup.propTypes = {
    type: PropTypes.oneOf(Object.values(SLOTS_GROUP_TYPES)),
    slots: PropTypes.array,
    isTouch: PropTypes.bool
};
