import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {FamilyAvatar} from '../../FamilyAvatar';

import './FamilySlotsListCard.styl';

const b = cn('FamilySlotsListCard');

export class FamilySlotsListCard extends React.Component {
    render() {
        const {dataT, title, description, onClick, slot, children} = this.props;

        return (
            <div className={b({stub: slot.isStub})} onClick={onClick} data-t={dataT}>
                <div className={b('top')}>
                    <div className={b('avatar')}>
                        <FamilyAvatar slot={slot} size='l' isCentered={true} />
                    </div>
                    <div className={b('title', {isGrey: slot.isEmpty})}>{title}</div>
                    {Boolean(description) && <div className={b('description')}>{description}</div>}
                </div>
                <div className={b('bottom')}>{children}</div>
            </div>
        );
    }
}

FamilySlotsListCard.propTypes = {
    isTouch: PropTypes.bool,
    slot: PropTypes.object,
    children: PropTypes.node,
    onClick: PropTypes.func,
    dataT: PropTypes.string,
    title: PropTypes.string,
    description: PropTypes.string
};
