import {connect} from 'react-redux';
import {FamilySlotsList as SlotsList} from './FamilySlotsList';
import {setCurrentSlot} from '../../middlewares/actions/common';
import {goToPage, goToInvitePage} from '../../middlewares/routing';

const mapStateToProps = ({family: {loading = false, hideFamilyInvite}, settings: {isTouch = false}} = {}) => ({
    loading,
    hideFamilyInvite,
    isTouch
});

const mapDispatchToProps = {goToPage, goToInvitePage, setCurrentSlot};

export const FamilySlotsList = connect(mapStateToProps, mapDispatchToProps)(SlotsList);
