import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {addCurrencySymbol} from '../../utils/currency';
import {LIMIT_MODES} from '../../const';

import './FamilyTileLimitInfo.styl';

const b = cn('FamilyTileLimitInfo');

const STATE = {PROHIBITED: 'prohibited', NO_LIMIT: 'nolimit', DISABLED: 'disabled', ENABLED: 'enabled'};
const BOTTOM_TEXTS = {
    [STATE.PROHIBITED]: i18n('Family.tileLimitInfo.prohibited'),
    [STATE.NO_LIMIT]: i18n('Family.tileLimitInfo.nolimit'),
    [STATE.DISABLED]: i18n('Family.tileLimitInfo.disabled')
};

export class FamilyTileLimitInfo extends React.Component {
    getState = () => {
        const {limitMode, value, slot: {isAbleToUsePay = false} = {}, isCardActualyEnabled} = this.props;

        if (!isAbleToUsePay) {
            return STATE.PROHIBITED;
        }

        if ((value || limitMode === LIMIT_MODES.NOLIMIT) && isCardActualyEnabled) {
            return limitMode === LIMIT_MODES.NOLIMIT ? STATE.NO_LIMIT : STATE.ENABLED;
        }

        return STATE.DISABLED;
    };
    render() {
        const {
            value,
            balance,
            currency,
            bound,
            language,
            isFamilyPayExp,
            slot: {isAdmin = false, isUser = false} = {},
            yourSlot: {isAbleToUsePay = false} = {},
            isAdminAccess,
            isRow
        } = this.props;

        if (!bound || !isUser || isAdmin || !isAdminAccess || !isAbleToUsePay || !isFamilyPayExp) {
            return null;
        }
        const state = this.getState();
        const balancePercent = Math.max((balance / value) * 100, 5);

        return (
            <div className={b({state, isRow})}>
                <div className={b('top')}>
                    {state === STATE.ENABLED ? (
                        <div className={b('text', {top: true})}>{addCurrencySymbol(balance, currency, language)}</div>
                    ) : (
                        <div className={b('icon')} />
                    )}
                </div>
                <div className={b('bottom')}>
                    {state === STATE.ENABLED ? (
                        <div className={b('barWrap')}>
                            <div
                                className={b('bar', {
                                    red: balancePercent < 10,
                                    yellow: balancePercent < 40 && balancePercent >= 10,
                                    green: balancePercent >= 40
                                })}
                                style={{width: `${balancePercent}%`}}
                            />
                        </div>
                    ) : (
                        <div className={b('text', {bottom: true})}>{BOTTOM_TEXTS[state]}</div>
                    )}
                </div>
            </div>
        );
    }
}

FamilyTileLimitInfo.propTypes = {
    limitMode: PropTypes.string,
    currency: PropTypes.string,
    language: PropTypes.string,
    slot: PropTypes.object,
    yourSlot: PropTypes.object,
    balance: PropTypes.number,
    value: PropTypes.number,
    bound: PropTypes.bool,
    isRow: PropTypes.bool,
    isFamilyPayExp: PropTypes.bool,
    isCardActualyEnabled: PropTypes.bool,
    isAdminAccess: PropTypes.bool
};
