import {connect} from 'react-redux';
import {hasExp} from '@blocks/selectors';
import {CURRENCIES} from '../../const';
import {FamilyTileLimitInfo as TileLimitInfo} from './FamilyTileLimitInfo';

const mapStateToProps = (state = {}, {slot: {placeId} = {}}) => {
    const {
        settings: {language} = {},
        family: {
            pay: {cardInfo: {bound} = {}, usersInfoByPlaceId = {}} = {},
            isAdminAccess = false,
            withPayOrigin,
            yourSlot = {}
        } = {}
    } = state;
    const {currency = CURRENCIES.RUB, limit: {limitMode, value} = {}, balance, isCardActualyEnabled} =
        usersInfoByPlaceId[placeId] || {};

    return {
        yourSlot,
        bound,
        limitMode,
        value,
        language,
        currency,
        balance,
        isCardActualyEnabled,
        isFamilyPayExp: hasExp(state, 'profile-family-pay-exp') || withPayOrigin || bound,
        isAdminAccess
    };
};

export const FamilyTileLimitInfo = connect(mapStateToProps)(TileLimitInfo);
