import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {UniversalTile} from '@components/UniversalTile';
import {FamilyAvatar} from '../FamilyAvatar';
import './FamilyUniversalTile.styl';

const b = cn('FamilyUniversalTile');

const ICONS = [
    'card',
    'card2',
    'ban',
    'stars',
    'plus',
    '3points',
    '9points',
    'arrowRight',
    'share',
    'repeat',
    'infinity',
    'check',
    'download',
    'arrowBottom',
    'addMember'
];

export const FamilyUniversalTile = ({
    type = 'button',
    verticalAlignCenter = false,
    label,
    title,
    description,
    onClick,
    isDisabled = false,
    iconLeft,
    iconLeftBg,
    avatarLeft,
    isMultiAvatar = false,
    slots = [],
    avatarSize = 's',
    iconRight,
    iconRightComponent,
    iconRightRotate = false,
    iconRightPosition,
    dataT = '',
    dataId = '',
    isTouch,
    href,
    avatarNoPlus = false,
    backgroundColor = '',
    backgroundHoverColor = '',
    titleEllipsisOverflow = false,
    descriptionEllipsisOverflow = false,
    isNoClickable = false
}) => (
    <div className={b({isDisabled, isClickable: Boolean(onClick)})}>
        <UniversalTile
            type={type}
            verticalAlignCenter={verticalAlignCenter}
            label={label}
            title={title}
            href={href}
            titleEllipsisOverflow={titleEllipsisOverflow}
            handler={onClick}
            description={description}
            descriptionEllipsisOverflow={descriptionEllipsisOverflow}
            leftComponent={
                <>
                    {iconLeft && <div className={b('icon', {[iconLeft]: true, bg: iconLeftBg})} />}
                    {avatarLeft && (
                        <FamilyAvatar
                            noPlus={avatarNoPlus}
                            slot={avatarLeft}
                            size={avatarSize}
                            isMultiAvatar={isMultiAvatar}
                            slots={slots}
                        />
                    )}
                </>
            }
            rightComponent={
                iconRightComponent && iconRight ? (
                    <div className={b('iconWithComponent')}>
                        {iconRightComponent}
                        <div
                            className={b('icon', {
                                [iconRight]: true,
                                position: iconRightPosition,
                                rotate: iconRightRotate
                            })}
                        />
                    </div>
                ) : (
                    <>
                        {Boolean(iconRightComponent) && (
                            <div
                                className={b('icon', {
                                    position: iconRightPosition,
                                    rotate: iconRightRotate
                                })}
                            >
                                {iconRightComponent}
                            </div>
                        )}
                        {iconRight && (
                            <div
                                className={b('icon', {
                                    [iconRight]: true,
                                    position: iconRightPosition,
                                    rotate: iconRightRotate
                                })}
                            />
                        )}
                    </>
                )
            }
            isNoClickable={isNoClickable}
            dataT={dataT}
            dataId={dataId}
            isTouch={isTouch}
            backgroundColor={backgroundColor}
            backgroundHoverColor={backgroundHoverColor}
        />
    </div>
);

FamilyUniversalTile.propTypes = {
    type: PropTypes.oneOf(['block', 'link', 'button']),
    label: PropTypes.string,
    title: PropTypes.string,
    verticalAlignCenter: PropTypes.bool,
    description: PropTypes.string,
    onClick: PropTypes.func,
    isDisabled: PropTypes.bool,
    iconLeft: PropTypes.oneOf(ICONS),
    iconLeftBg: PropTypes.bool,
    avatarLeft: PropTypes.object,
    avatarSize: PropTypes.string,
    iconRight: PropTypes.oneOf(ICONS),
    iconRightComponent: PropTypes.node,
    iconRightRotate: PropTypes.bool,
    iconRightPosition: PropTypes.string,
    dataT: PropTypes.string,
    dataId: PropTypes.string,
    href: PropTypes.string,
    isTouch: PropTypes.bool,
    isMultiAvatar: PropTypes.bool,
    slots: PropTypes.array,
    avatarNoPlus: PropTypes.bool,
    backgroundColor: PropTypes.string,
    backgroundHoverColor: PropTypes.string,
    titleEllipsisOverflow: PropTypes.bool,
    descriptionEllipsisOverflow: PropTypes.bool,
    isNoClickable: PropTypes.bool
};
