import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {FamilyUniversalTile} from '../FamilyUniversalTile';
import './FamilyUniversalTileList.styl';

const b = cn('FamilyUniversalTileList');

const renderOneTile = (tile, index) =>
    tile && (
        <React.Fragment key={index}>
            {Boolean(index) && <div className={b('sep')} />}
            <div className={b('tile')}>
                <FamilyUniversalTile {...tile} />
            </div>
        </React.Fragment>
    );

export const FamilyUniversalTileList = ({tiles = []}) => <div className={b()}>{tiles.map(renderOneTile)}</div>;

FamilyUniversalTileList.propTypes = {
    tiles: PropTypes.array
};
