import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import './FamilyWarning.styl';

const b = cn('FamilyWarning');

export const FamilyWarning = ({text, icon}) => (
    <div className={b()}>
        <div className={b('icon', {[icon || 'default']: true})} />
        <div className={b('text')}>{text}</div>
    </div>
);

FamilyWarning.propTypes = {
    text: PropTypes.string,
    icon: PropTypes.string
};
