import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Logo} from '@blocks/pushes/icons/Logo/Logo';
import {CloseButton} from '@blocks/pushes/components/CloseButton/CloseButton';
import {redirectToRetpathFromWebview} from '@blocks/utils';
import {WEBVIEW_STATUS_CLOSE} from '@blocks/constants';
import './FamilyWebviewHeader.styl';

const b = cn('FamilyWebviewHeader');

export class FamilyWebviewHeader extends React.Component {
    onCloseButtonClick = () => {
        const {isAm, isWebview, retpath, finishCancelUrl} = this.props;

        if (isAm) {
            return (window.location.href = finishCancelUrl);
        }

        if (isWebview) {
            return redirectToRetpathFromWebview(retpath, WEBVIEW_STATUS_CLOSE);
        }
    };

    render() {
        const {hideWebviewHeader} = this.props;

        return hideWebviewHeader ? null : (
            <div className={b()}>
                <Logo className={b('logo')} />
                <CloseButton closeHandler={this.onCloseButtonClick} />
            </div>
        );
    }
}

FamilyWebviewHeader.propTypes = {
    retpath: PropTypes.string,
    isWebview: PropTypes.bool,
    isAm: PropTypes.bool,
    finishCancelUrl: PropTypes.string,
    hideWebviewHeader: PropTypes.bool
};
