import {WEBVIEW_STATUS_CLOSE} from '@blocks/constants';

// При изменении/добавлении продублировать при необходимости в FamilyPageSelectorLazy!!!
export const PAGES = {
    loading: 'loading',
    main: 'main',
    empty: 'main.empty',
    fakeMain: 'main.fake',
    stub: 'main.stub',
    invite: 'invite.create',
    inviteCancel: 'invite.cancel',
    inviteInfo: 'invite.info',
    inviteRedesign: 'invite.redesign',
    inviteWelcome: 'invite.welcome',
    inviteAcceptWarning: 'invite.warning',
    memberExclude: 'member.exclude',
    memberLeave: 'member.leave',
    slotInfo: 'slot.info',
    inviteShare: 'invite.share',
    inviteSend: 'invite.send',
    inviteCreated: 'invite.created',
    kiddish: 'kiddish',
    inviteAccept: 'invite.accept',
    kiddishName: 'kiddish.name',
    kiddishAvatar: 'kiddish.avatar',
    kiddishRating: 'kiddish.rating',
    kiddishMusic: 'kiddish.music',
    kiddishFilms: 'kiddish.films',
    kiddishOther: 'kiddish.other',
    kiddishRemove: 'kiddish.remove',
    payCards: 'pay.cards',
    payUnbind: 'pay.unbind',
    payLimits: 'pay.limits',
    payLimitsMember: 'pay.limitsMember',
    payAfter3ds: 'pay.after3ds',
    childishControl: 'childish.control',
    childishRating: 'childish.rating',
    childishDelete: 'childish.delete',
    childishLanding: 'childish.landing',
    error: 'error',
    addCard: 'add.card',
    addPhone: 'add.phone'
};

export const PAGE_SELECTOR_TYPES = {
    FULL: 'full',
    MODAL: 'modal'
    // Место зарезервировано для шторки
};

export const KIDDISH_PAGES = [
    PAGES.kiddishName,
    PAGES.kiddishFilms,
    PAGES.kiddishOther,
    PAGES.kiddishRating,
    PAGES.kiddishRemove,
    PAGES.kiddishAvatar,
    PAGES.kiddishMusic
];

export const KIDDISH_PAGES_TYPES = {
    AVATAR: 'avatar',
    NAME: 'name',
    RATING: 'rating',
    FILMS: 'films',
    MUSIC: 'music',
    OTHER: 'other'
};

export const METRIC_KIDDISH_PAGES_TYPES = {
    [KIDDISH_PAGES_TYPES.AVATAR]: 'Аватар',
    [KIDDISH_PAGES_TYPES.NAME]: 'Имя',
    [KIDDISH_PAGES_TYPES.RATING]: 'Общий рейтинг',
    [KIDDISH_PAGES_TYPES.FILMS]: 'Рейтинг видео',
    [KIDDISH_PAGES_TYPES.MUSIC]: 'Рейтинг музыки',
    [KIDDISH_PAGES_TYPES.OTHER]: 'Остальное'
};

export const KIDDISH_PAGES_INFO = {
    [PAGES.kiddishAvatar]: {
        step: null,
        type: KIDDISH_PAGES_TYPES.AVATAR,
        prev: PAGES.kiddishName,
        next: PAGES.kiddishName
    },
    [PAGES.kiddishName]: {
        step: 1,
        type: KIDDISH_PAGES_TYPES.NAME,
        prev: null,
        next: PAGES.kiddishRating
    },
    [PAGES.kiddishRating]: {
        step: 2,
        type: KIDDISH_PAGES_TYPES.RATING,
        prev: PAGES.kiddishName,
        next: PAGES.kiddishOther
    },
    [PAGES.kiddishOther]: {
        step: 3,
        type: KIDDISH_PAGES_TYPES.OTHER,
        prev: PAGES.kiddishRating,
        next: null
    },
    STEPS_COUNT: 3
};

export const KIDDISH_PAGES_INFO_EDIT = {
    [PAGES.kiddishAvatar]: {
        step: null,
        type: KIDDISH_PAGES_TYPES.AVATAR,
        prev: PAGES.kiddishName,
        next: PAGES.kiddishName
    },
    [PAGES.kiddishName]: {
        step: 1,
        type: KIDDISH_PAGES_TYPES.NAME,
        prev: null,
        next: PAGES.kiddishFilms
    },
    [PAGES.kiddishFilms]: {
        step: 2,
        type: KIDDISH_PAGES_TYPES.FILMS,
        prev: PAGES.kiddishName,
        next: PAGES.kiddishOther
        /* PASSP-33111
        next: PAGES.kiddishMusic
    },
    [PAGES.kiddishMusic]: {
        step: 3,
        type: KIDDISH_PAGES_TYPES.MUSIC,
        prev: PAGES.kiddishFilms,
        next: PAGES.kiddishOther
    */
    },
    [PAGES.kiddishOther]: {
        step: 3,
        type: KIDDISH_PAGES_TYPES.OTHER,
        prev: PAGES.kiddishFilms,
        next: null
    },
    STEPS_COUNT: 3
};

export const KIDDISH_AVATARS_TEST = [
    '1824/H8N2Qejv2ir9BZ5BfqPfHrimVU-1', // голубой
    '1824/Gj8Rr4B4WRJicXpAbRa2eUNdALs-1', // зеленый
    '1824/7MPDqnIVvz6kgggDr66m3pYQw-1', // бирюзовый
    '1824/czSwsiRnpA28p4LnJhP1CJ8KEDc-1', // малиновый
    '1824/mD5ArcGzeISMXht9SOqoRGL11E-1', // розовый
    '1450/5jGo5jvjgnMuj2gsBqJt2naJb4-1', // пурпурный
    '1450/bDwjUNw9bc9BmSiYuqlXRu5I5rM-1', // желтый
    '1450/mcjIULz4L9t2uAnuBVfedcJFG64-1', // красный
    '1450/8R67IFOdmLeJfOFDxcuTmzZKU-1', // синий
    '1450/CMp8S8LkLYQPpIwQNGWM25roMlc-1' // бледно-розовый
];

export const KIDDISH_AVATARS_PROD = [
    '63032/z5w9g2wrGDtwxWnibIWn3OBbO4-1', // голубой
    '65952/TdsAbxuNgKBp4idLnOZN646Ug-1', // зеленый
    '45566/PMYm3KNlixr1Ls088GSJP2nHtE-1', // бирюзовый
    '68143/R7reaPIakndRs2HKtfxcYoaAxFI-1', // малиновый
    '49368/KHFyoUP8CrwLT22QH2kzJn0RgxI-1', // розовый
    '64336/Koh5leddmqpm5bup8IUTSDFbTZk-1', // пурпурный
    '28053/2w3QvweQRYLktuT61SqaVUWe7X0-1', // желтый
    '49368/K9lUQYxK0nQuWKd7BKND4mWI3g-1', // красный
    '38663/F6IADZtmOvTv7L1MU0gOCkn8U-1', // синий
    '48449/lmS3ByKYSsQo9R79oIXtfRngNTU-1' // бледно-розовый
];

export const KIDDISH_SLIDERS = {
    FILMS: {
        count: 5,
        ages: [0, 6, 12, 16, 18],
        field: 'videoRating'
    },
    MUSIC: {
        count: 3,
        ages: [0, 18],
        field: 'musicRating'
    },
    COMMON: {
        count: 5,
        ages: [0, 6, 12, 16, 18],
        field: 'rating'
    }
};

export const CHILDISH_SLIDERS = {
    COMMON: {
        count: 5,
        ages: [0, 6, 12, 16, 18],
        field: 'rating'
    }
};

export const CARDS = {
    pay: 'pay',
    plusSmall: 'plusSmall',
    loading: 'loading',
    join: 'join',
    create: 'create',
    kiddish: 'kiddish',
    plus: 'plus'
};

export const INVITE_METHODS = {
    EMAIL: 'email',
    SMS: 'sms'
};

export const SLOTS_GROUP_TYPES = {
    MEMBER: 'member',
    KIDDISH: 'kiddish',
    CHILDISH: 'childish'
};

export const SLOT_TYPES = {
    EMPTY: 'empty',
    INVITE: 'invite',
    KIDDISH: 'kiddish',
    STUB: 'stub',
    USER: 'user'
};

export const KIDDISH_INPUT_FIELDS = {
    NAME: 'name',
    AVATAR: 'tmpAvatar',
    GENDER: 'gender',
    BIRTHDAY: 'birthday'
};

export const PAY_SERVICES = {
    market: i18n('Family.pay.services.market'),
    eats: i18n('Family.pay.services.eda'),
    taxi: i18n('Family.pay.services.taxi'),
    drive: i18n('Family.pay.services.drive'),
    lavka: i18n('Family.pay.services.lavka'),
    kinopoisk: i18n('Family.pay.services.kinopoisk'),
    travel: i18n('Family.pay.services.travel'),
    games: i18n('Family.pay.services.games'),
    dostavka: i18n('Family.pay.services.dostavka'),
    tanker: i18n('Family.pay.services.tanker'),
    afisha: i18n('Family.pay.services.afisha'),
    health: i18n('Family.pay.services.health'),
    help: i18n('Family.pay.services.help')
};

export const LIMIT_MODES = {
    DAY: 'DAY',
    WEEK: 'WEEK',
    MONTH: 'MONTH',
    TOTAL: 'TOTAL',
    NOLIMIT: 'NOLIMIT'
};

export const MAX_LIMIT = 100000;

export const ERRORS_BUTTON_ACTIONS = {
    reload: 'reload',
    reset: 'reset',
    goToKiddishName: 'goToKiddishName',
    redirectToMain: 'redirectToMain',
    relogin: 'relogin',
    nothing: 'nothing'
};

export const ACCEPT_INVITE_TEXTS = {
    titles: {
        invite: i18n('Family.inviteAccept.kids.warn.title'),
        inviteWarn: i18n('Family.inviteAccept.warn.title'),
        inviteWarnAdminWithMembers: i18n('Family.inviteAccept.warnAdminWithMembers.title'),
        leaveConfirm: i18n('Family.inviteAccept.leaveConfirm'),
        leaveConfirmSimple: i18n('Family.inviteAccept.leave.title'),
        welcome: i18n('Family.inviteAccept.welcome.title'),
        yourFamily: i18n('Family.inviteAccept.link.yourFamily.title'),
        inviteOutdated: i18n('Family.inviteAccept.link.outdated.title'),
        inviteInvalid: i18n('Family.inviteAccept.link.invalid.title')
    },
    texts: {
        inviteWarn: i18n('Family.inviteAccept.warn.text'),
        inviteWarnAdminWithMembers: i18n('Family.inviteAccept.warnAdminWithMembers.text'),
        inviteKidsWarn: i18n('Family.inviteAccept.kids.warn.text'),
        inviteWarnUser: i18n('Family.inviteAccept.warn.user.text'),
        invite: i18n('Family.inviteAccept.user.text'),
        leaveConfirm: i18n('Family.inviteAccept.leaveText'),
        leaveConfirmSimple: i18n('Family.inviteAccept.leave.text'),
        welcome: i18n('Family.inviteAccept.welcome.text'),
        welcomeNoPay: i18n('Family.inviteAccept.nocard.welcome.text'),
        yourFamily: {
            admin: i18n('Family.inviteAccept.link.yourFamily.text.admin'),
            member: i18n('Family.inviteAccept.link.yourFamily.text.member')
        },
        inviteOutdated: i18n('Family.inviteAccept.link.outdated.text'),
        inviteInvalid: i18n('Family.inviteAccept.link.invalid.text')
    },
    buttons: {
        joinFamily: i18n('Family.joinFamily.button'),
        ok: i18n('Family.error.button'),
        changeFamily: i18n('Family.inviteAccept.changeFamily.button'),
        stayInFamily: i18n('Family.stay.button'),
        doNothing: i18n('Family.doNothing.button'),
        perfect: i18n('Family.invite-confirm.confirmed.button')
    }
};

const createErrorButton = (action, view = 'action', text = i18n('Family.error.button')) => ({action, view, text});

export const ERRORS = {
    default: {
        title: i18n('Family.error.title.common'),
        message: i18n('Family.error.message.common'),
        buttons: [createErrorButton(ERRORS_BUTTON_ACTIONS.reload)]
    },
    ['family.does_not_exist']: {
        title: i18n('Family.error.title.common'),
        message: i18n('Family.error.message.does_not_exist'),
        buttons: [createErrorButton(ERRORS_BUTTON_ACTIONS.redirectToMain)]
    },
    ['family.not_is_admin']: {
        title: i18n('Family.error.title.common'),
        message: i18n('Family.error.message.not_is_admin'),
        buttons: [createErrorButton(ERRORS_BUTTON_ACTIONS.redirectToMain)]
    },
    ['family.already_exists']: {
        title: i18n('Family.error.title.already_exists'),
        message: i18n('Family.error.message.already_exists'),
        buttons: [createErrorButton(ERRORS_BUTTON_ACTIONS.reset)]
    },
    ['family.is_not_a_member']: {
        title: i18n('Family.error.title.is_not_a_member'),
        message: i18n('Family.error.message.is_not_a_member'),
        buttons: [createErrorButton(ERRORS_BUTTON_ACTIONS.reset)]
    },
    ['family.is_admin']: {
        title: i18n('Family.error.title.is_admin'),
        message: i18n('Family.error.message.is_admin'),
        buttons: [createErrorButton(ERRORS_BUTTON_ACTIONS.reset)]
    },
    ['family.max_capacity']: {
        title: i18n('Family.error.title.max_capacity'),
        message: i18n('Family.error.message.max_capacity'),
        buttons: [createErrorButton(ERRORS_BUTTON_ACTIONS.reset)]
    },
    ['kiddish.max_capacity']: {
        title: i18n('Family.error.title.kiddish_max_capacity'),
        message: i18n('Family.error.message.kiddish_max_capacity'),
        buttons: [createErrorButton(ERRORS_BUTTON_ACTIONS.reset)]
    },
    ['family.invalid_invite']: {
        title: ACCEPT_INVITE_TEXTS.titles.inviteInvalid,
        message: ACCEPT_INVITE_TEXTS.texts.inviteInvalid,
        buttons: [
            {
                action: ERRORS_BUTTON_ACTIONS.redirectToMain,
                view: 'action',
                text: ACCEPT_INVITE_TEXTS.buttons.ok,
                metric: ['Приглашение недействительно: нажали на кнопку "Понятно"'],
                webviewStatus: WEBVIEW_STATUS_CLOSE
            }
        ]
    },
    ['family.is_member_this']: {
        title: i18n('Family.error.title.is_member_this'),
        message: i18n('Family.error.message.is_member_this'),
        buttons: [createErrorButton(ERRORS_BUTTON_ACTIONS.redirectToMain)]
    },
    ['family.is_member_other']: {
        title: i18n('Family.error.title.is_member_other'),
        message: i18n('Family.error.message.is_member_other'),
        buttons: [
            createErrorButton(ERRORS_BUTTON_ACTIONS.redirectToMain),
            createErrorButton(ERRORS_BUTTON_ACTIONS.relogin, 'default', i18n('Family.error.button.relogin'))
        ]
    },
    ['sms_phone.invalid']: {
        title: i18n('Family.error.title.sms_phone.invalid'),
        message: i18n('Family.error.message.sms_phone.invalid'),
        buttons: [createErrorButton(ERRORS_BUTTON_ACTIONS.nothing)]
    },
    ['sms_phone.empty']: {
        title: i18n('Family.error.title.sms_phone.invalid'),
        message: i18n('Family.error.message.sms_phone.invalid'),
        buttons: [createErrorButton(ERRORS_BUTTON_ACTIONS.nothing)]
    },
    ['display_name.invalid']: {
        title: i18n('Family.error.title'),
        message: i18n('Family.error.message.display_name.invalid'),
        buttons: [createErrorButton(ERRORS_BUTTON_ACTIONS.goToKiddishName)]
    },
    ['family.cant_remove_invite']: {
        title: i18n('Family.error.title.cant_remove_invite'),
        message: i18n('Family.error.message.cant_remove_invite'),
        buttons: [createErrorButton(ERRORS_BUTTON_ACTIONS.reset)]
    },
    ['account.not_found']: {
        title: i18n('Family.error.title'),
        message: i18n('Family.error.message.account.not_found'),
        buttons: [createErrorButton(ERRORS_BUTTON_ACTIONS.reset)]
    },
    ['rate.limit_exceeded']: {
        title: i18n('Family.error.title.rate.limit_exceeded'),
        message: i18n('Family.error.message.rate.limit_exceeded'),
        buttons: [createErrorButton(ERRORS_BUTTON_ACTIONS.nothing)]
    },
    ['invite_id.invalid']: {
        title: ACCEPT_INVITE_TEXTS.titles.inviteOutdated,
        message: ACCEPT_INVITE_TEXTS.texts.inviteOutdated,
        decor: 'clock',
        buttons: [
            {
                action: ERRORS_BUTTON_ACTIONS.redirectToMain,
                view: 'action',
                text: ACCEPT_INVITE_TEXTS.buttons.ok,
                metric: ['Приглашение недействительно: нажали на кнопку "Понятно"'],
                webviewStatus: WEBVIEW_STATUS_CLOSE
            }
        ]
    }
};

export const METRIC_PREFIXES = {
    FAMILY: 'Семейная группа',
    KIDDISH: 'Детские профили',
    PAY: 'Семейная оплата'
};

export const METRIC_KIDDISH_CREATE = 'Создание';
export const METRIC_KIDDISH_EDIT = 'Редактирование';
export const METRIC_KIDDISH_REMOVE = 'Удаление';
export const METRIC_KIDDISH_PROFILE = 'Просмотр профиля';

export const CONTACT_US_URL = 'https://yandex.%tld%/support/passport/subscriptions.html';
export const CONTACT_US_UZ_URL = 'https://yandex.uz/support/plus/';
export const CONTACT_US_FAMILY_URL = 'https://id.yandex.%tld%/support/e0271d00-30f7-9cf7-4c16-c3f95d5b10cd';

export const ROUTES = {
    main: ['/profile/family', '/profile/family/', '/am/push/family', '/am/push/family/'],
    invite: ['/profile/family/invite', '/profile/family/invite/'],
    welcome: ['/profile/family/welcome', '/profile/family/welcome/'],
    after3ds: ['/profile/family/after3ds', '/profile/family/after3ds/'],
    payCards: ['/profile/family/pay-cards', '/profile/family/pay-cards/'],
    kiddish: ['/profile/family/kids', '/profile/family/kids/']
};

// eslint-disable-next-line no-useless-escape
export const ACCEPT_INVITE_ROUTE_REGEX = /^\/profile\/family\/invite\/[^\/]*[a-z][^\/]*\/?$/i;
// eslint-disable-next-line no-useless-escape
export const ACCEPT_INVITE_WEBVIEW_ROUTE_REGEX = /^\/profile\/family-webview?\/invite\/[^\/]*[a-z][^\/]*\/?$/i;

export const FAMILY_ENTRY_PAGES_METRICS_MAP = {
    '/profile/family': 'Показ главной страницы семьи',
    '/profile/family/': 'Показ главной страницы семьи',
    '/profile/family/kids': 'Показ страницы семьи с детскими профилями',
    '/profile/family/kids/': 'Показ страницы семьи с детскими профилями',
    '/profile/family/invite': 'Показ страницы семьи с созданием инвайта',
    '/profile/family/invite/': 'Показ страницы семьи с созданием инвайта',
    '/profile/family-webview/pay-cards': 'Показ страницы семьи с добавлением семейной карты в вебвью',
    '/profile/family-webview/pay-cards/': 'Показ страницы семьи с добавлением семейной карты в вебвью',
    '/profile/family-webview/delete-member': 'Показ страницы семьи с удалением участника семьи в вебвью',
    '/profile/family-webview/delete-member/': 'Показ страницы семьи с удалением участника семьи в вебвью',
    '/profile/family-webview/leave-member': 'Показ страницы семьи с выходом участника из семьи в вебвью',
    '/profile/family-webview/leave-member/': 'Показ страницы семьи с выходом участника из семьи в вебвью',
    '/profile/family-webview/invite-slot': 'Показ страницы семьи со слотом инвайта в вебвью',
    '/profile/family-webview/invite-slot/': 'Показ страницы семьи со слотом инвайта в вебвью',
    limits: 'Форма лимитов',
    limitsWebview: 'Форма лимитов в вебвью',
    acceptInvite: 'Показ страницы семьи с принятием инвайта',
    acceptInviteWebview: 'Показ страницы семьи с принятием инвайта в вебвью',
    default: 'Показ главной страницы семьи'
};

export const CURRENCIES = {
    RUB: 'RUB',
    USD: 'USD',
    EUR: 'EUR',
    BYN: 'BYN',
    KZT: 'KZT',
    AMD: 'AMD',
    ILS: 'ILS'
};

export const CURRENCIES_LIST = Object.keys(CURRENCIES);
export const CURRENCIES_BEFORE_VALUE = [CURRENCIES.USD];

export const SESSION_STORAGE_KEYS = {
    NO_FAMILY_BEFORE_CHAAS: 'NO_FAMILY_BEFORE_CHAAS'
};
