import {connect} from 'react-redux';
import {goToMainPage, goToInvitePage, goToLoadingPage, goToKiddishPage, goToPage} from '../middlewares/routing';
import {fetchFamily} from '../middlewares/api/state';
import {fetchInvite} from '../middlewares/api/invite';

import {setFamilyInviteId} from '../actions';
import FamilyComponent from './family.jsx';

const mapStateToProps = (state, {match: {params: {inviteId} = {}} = {}}) => ({inviteId});
const mapDispatchToProps = {
    fetchFamily,
    goToPage,
    goToMainPage,
    goToLoadingPage,
    goToInvitePage,
    goToKiddishPage,
    fetchInvite,
    setFamilyInviteId
};

export default connect(mapStateToProps, mapDispatchToProps)(FamilyComponent);
