import React from 'react';
import PropTypes from 'prop-types';
import {metrics} from '../utils/metrics';
import {FamilyInviteConfirmPage, FamilyErrorPage} from '../pages';

export class FamilyInvite extends React.Component {
    componentDidMount = () => {
        metrics.send(['Показ страницы семьи с подтверждением инвайта']);
        this.fetchInvite();
    };
    fetchInvite = () => {
        const {fetchInvite, inviteId} = this.props;

        fetchInvite(inviteId);
    };
    render() {
        const {family: {error} = {}, inviteId} = this.props;

        return error ? (
            <FamilyErrorPage onResetClick={this.fetchInvite} />
        ) : (
            <FamilyInviteConfirmPage inviteId={inviteId} />
        );
    }
}

FamilyInvite.propTypes = {
    family: PropTypes.object,
    inviteId: PropTypes.string,
    fetchInvite: PropTypes.func,
    retpath: PropTypes.string
};
