import React from 'react';
import PropTypes from 'prop-types';
import {FamilyPageSelectorLazyFull} from '../../page-selectors/lazy/full';
import {FamilyNotification} from '../../components/FamilyNotification';
import {sendShownPageMetric} from '../../utils/sendShownPageMetric';

import './lazy.styl';

export class FamilyLazy extends React.Component {
    componentDidMount() {
        const {pathname, hasFamilySubscription, hasFamily, fetchFamily} = this.props;

        sendShownPageMetric(pathname, hasFamilySubscription, hasFamily);
        fetchFamily();
    }
    render() {
        return (
            <>
                <FamilyPageSelectorLazyFull />
                <FamilyNotification />
            </>
        );
    }
}

FamilyLazy.propTypes = {
    pathname: PropTypes.string,
    hasFamily: PropTypes.bool,
    hasFamilySubscription: PropTypes.bool,
    fetchFamily: PropTypes.func
};
