import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {FamilyButton} from '@blocks/morda/new/family/components/FamilyButton';
import {FamilyLayout} from '@blocks/morda/new/family/components/FamilyLayout';
import {FamilyAvatar} from '@blocks/morda/new/family/components/FamilyAvatar';
import './FamilyActionLayout.styl';

const b = cn('FamilyActionLayout');
const baseDataT = 'family:action:layout';

export const FamilyActionLayout = ({
    avatar,
    decor,
    supertitle,
    title,
    text,
    textView,
    hideBackButton,
    children,
    buttons = [],
    dataTPostfix = ''
}) => {
    return (
        <FamilyLayout hideBackButton={hideBackButton}>
            <div className={b()} data-t={dataTPostfix ? `${baseDataT}:${dataTPostfix}` : baseDataT}>
                {decor && (
                    <div className={b('decor', {decor, negativeTopMargin: !hideBackButton})} aria-hidden='true' />
                )}
                {avatar && <FamilyAvatar slot={avatar} size='l' isCentered={true} />}
                {supertitle && <div className={b('supertitle')}>{supertitle}</div>}
                <h2 className={b('title', {noText: !text, noContent: !children})}>{title}</h2>
                {text && <div className={b('text', {view: textView})}>{text}</div>}
                {children && <div className={b('children')}>{children}</div>}
                {Boolean(buttons.length) && (
                    <div className={b('buttons')}>
                        {buttons.map((button, index) => button && <FamilyButton {...button} key={index} />)}
                    </div>
                )}
            </div>
        </FamilyLayout>
    );
};

FamilyActionLayout.propTypes = {
    decor: PropTypes.string,
    supertitle: PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    title: PropTypes.string,
    text: PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    textView: PropTypes.string,
    hideBackButton: PropTypes.bool,
    children: PropTypes.node,
    buttons: PropTypes.arrayOf(
        PropTypes.shape({
            text: PropTypes.string,
            view: PropTypes.oneOf(['action', 'transparent', 'default']),
            onClick: PropTypes.func
        })
    ),
    avatar: PropTypes.object,
    dataTPostfix: PropTypes.string
};
