import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {LoaderId} from '@components/LoaderId';
import {FamilyLayout} from '../../components/FamilyLayout';

import './FamilyAddCardLayout.styl';

const b = cn('FamilyAddCardLayout');

export const FamilyAddCardLayout = ({loading, hideBackButton, smallSidePadding, mediumMaxWidthOnTouch, children}) => (
    <FamilyLayout
        smallSidePadding={smallSidePadding}
        mediumMaxWidthOnTouch={mediumMaxWidthOnTouch}
        hideBackButton={hideBackButton}
    >
        <div className={b({loading: !children, marginTop: !hideBackButton})} data-t='family:layout:add-card'>
            {children && !loading ? children : <LoaderId />}
        </div>
    </FamilyLayout>
);

FamilyAddCardLayout.propTypes = {
    smallSidePadding: PropTypes.bool,
    mediumMaxWidthOnTouch: PropTypes.bool,
    loading: PropTypes.bool,
    hideBackButton: PropTypes.bool,
    children: PropTypes.node
};
