import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {FamilyLayout} from '../../components/FamilyLayout';
import {FamilyButton} from '../../components/FamilyButton';
import {PAGE_SELECTOR_TYPES} from '../../const';

import './FamilyConfirmLayout.styl';

const b = cn('FamilyConfirmLayout');

export const FamilyConfirmLayout = ({
    title,
    text,
    agreeText,
    disagreeText,
    curPageSelector,
    onConfirm,
    onCancel,
    bigButtons = false,
    hideBackButton = false
}) => (
    <FamilyLayout hideBackButton={hideBackButton}>
        <div className={b({bigButtons})} data-t='family:layout:confirm'>
            <div className={b('title', {withPadding: curPageSelector === PAGE_SELECTOR_TYPES.MODAL})}>{title}</div>
            {Boolean(text) && <div className={b('text')}>{text}</div>}
            <div className={b('buttons')}>
                <div className={b('button')}>
                    <FamilyButton view='action' text={agreeText} onClick={onConfirm} dataT='agree' />
                </div>
                <div className={b('button')}>
                    <FamilyButton view='default' text={disagreeText} onClick={onCancel} dataT='disagree' />
                </div>
            </div>
        </div>
    </FamilyLayout>
);

FamilyConfirmLayout.propTypes = {
    title: PropTypes.string,
    text: PropTypes.string,
    agreeText: PropTypes.string,
    disagreeText: PropTypes.string,
    curPageSelector: PropTypes.string,
    hideBackButton: PropTypes.bool,
    bigButtons: PropTypes.bool,
    onConfirm: PropTypes.func,
    onCancel: PropTypes.func.isRequired
};
