import React from 'react';
import PropTypes from 'prop-types';
import {Spin} from '@components/Spin';
import {cn} from '@bem-react/classname';
import {FamilyLayout} from '../../components/FamilyLayout';
import {FamilyButton} from '../../components/FamilyButton';
import {FamilyAvatar} from '../../components/FamilyAvatar';
import './FamilyInviteConfirmLayout.styl';

const b = cn('FamilyInviteConfirmLayout');

export const FamilyInviteConfirmLayout = ({admin, showAvatar, text, description, buttons, isLoading}) => (
    <FamilyLayout isCard={true} isNotFixedWidthCard={true} isWhiteBgMobile={true} hideBackButton={true}>
        <div className={b({isLoading})} data-t='family:layout:invite-confirm'>
            {isLoading ? (
                <Spin progress={true} size='l' />
            ) : (
                <>
                    {Boolean(showAvatar && admin) && <FamilyAvatar slot={admin} size='m' isCentered={true} />}
                    <h2 className={b('text')}>{text}</h2>
                    {Boolean(description) && <div className={b('description')}>{description}</div>}
                    {Boolean(buttons.length) && (
                        <div className={b('buttons', {isHidden: admin.isLoading})}>
                            {buttons.map((button) => (
                                <FamilyButton {...button} key={button.text} />
                            ))}
                        </div>
                    )}
                </>
            )}
        </div>
    </FamilyLayout>
);

FamilyInviteConfirmLayout.propTypes = {
    admin: PropTypes.object,
    showAvatar: PropTypes.bool,
    text: PropTypes.string,
    description: PropTypes.string,
    buttons: PropTypes.arrayOf(
        PropTypes.shape({
            text: PropTypes.string,
            onClick: PropTypes.func,
            view: PropTypes.oneOf(['action', 'default', 'plus'])
        })
    ),
    isLoading: PropTypes.bool
};
