import {connect} from 'react-redux';
import {withPageSelectorContext} from '../../page-selectors/context';
import {setCurrentSlot} from '../../middlewares/actions/common';
import {goToKiddishPage, goToPage, goToMainPage} from '../../middlewares/routing';
import {postEditKiddish, postKiddish} from '../../middlewares/api/kiddish';
import {fetchFamily} from '../../middlewares/api/state';
import {FamilyInviteKiddishLayout as Layout} from './FamilyInviteKiddishLayout';

const mapStateToProps = (state) => {
    const {family: {currentSlot = {}, hasFamily, settings: {isTouch} = {}} = {}} = state;
    const {isKiddish = false, isKiddishOnlyThisStep = false} = currentSlot;

    return {currentSlot, isEditing: isKiddish, isKiddishOnlyThisStep, hasFamily, isTouch};
};
const mapDispatchToProps = {
    goToKiddishPage,
    goToPage,
    goToMainPage,
    postEditKiddish,
    postKiddish,
    setCurrentSlot,
    fetchFamily
};

export const FamilyInviteKiddishLayout = connect(mapStateToProps, mapDispatchToProps)(withPageSelectorContext(Layout));
