import React from 'react';
import PropTypes from 'prop-types';
import {FamilyLayout} from '../../components/FamilyLayout';
import {FamilyButton} from '../../components/FamilyButton';
import {FamilyInviteInput} from '../../components/FamilyInviteInput';
import {cn} from '@bem-react/classname';
import './FamilyInviteLayout.styl';

const b = cn('FamilyInviteLayout');
const INVITE_INPUT_ID = 'passport-family-ivite-input';

export class FamilyInviteLayout extends React.Component {
    render() {
        const {
            title,
            shareButtonText,
            inputLabel,
            shareText,
            inputPlaceholderText,
            signText,
            onShareInviteClick,
            onSendInviteClick
        } = this.props;

        return (
            <FamilyLayout>
                <div className={b()} data-t='family:layout:invite'>
                    <h2 className={b('title')}>{title}</h2>
                    <label className={b('label')} htmlFor={INVITE_INPUT_ID}>
                        {inputLabel}
                    </label>
                    <FamilyInviteInput
                        id={INVITE_INPUT_ID}
                        placeholderText={inputPlaceholderText}
                        sendInvite={onSendInviteClick}
                    />
                    <div className={b('shareText')}>{shareText}</div>
                    <div className={b('shareButton')}>
                        <FamilyButton
                            view='action'
                            onClick={onShareInviteClick}
                            text={shareButtonText}
                            metric={['Нажатие на кнопку "Сгенерировать приглашение"']}
                        />
                    </div>
                    <div className={b('sign')}>{signText}</div>
                </div>
            </FamilyLayout>
        );
    }
}

FamilyInviteLayout.propTypes = {
    title: PropTypes.string,
    shareButtonText: PropTypes.string,
    shareText: PropTypes.string,
    inputLabel: PropTypes.string,
    inputPlaceholderText: PropTypes.string,
    signText: PropTypes.string,
    onShareInviteClick: PropTypes.func,
    onSendInviteClick: PropTypes.func,
    onSendInviteClickDev: PropTypes.func
};
