import React from 'react';
import PropTypes from 'prop-types';
import {FamilyLayout} from '../../components/FamilyLayout';
import {cn} from '@bem-react/classname';
import './FamilyKiddishLayout.styl';
import {FamilyUniversalTileList} from '../../components/FamilyUniversalTileList';

const b = cn('FamilyKiddishLayout');
const dataT = 'family:kiddish-page';

export class FamilyKiddishLayout extends React.Component {
    renderTileList = () => {
        const {kiddishSlots, onAddKiddishClick, onKiddishClick} = this.props;

        return (
            <FamilyUniversalTileList
                tiles={kiddishSlots.map((slot, index) => {
                    if (slot.isEmpty) {
                        return {
                            type: 'button',
                            title: i18n('Family.kiddish.empty-slot'),
                            iconLeft: 'addMember',
                            onClick: onAddKiddishClick,
                            dataT: `${dataT}:slot:empty`
                        };
                    }

                    const {name = '', videoRating = '0'} = slot;

                    return {
                        type: 'button',
                        title: name,
                        titleEllipsisOverflow: true,
                        avatarLeft: slot,
                        avatarSize: 'xs',
                        description: `${i18n('Family.kiddish-page.options.films')} ${videoRating}+`,
                        onClick: onKiddishClick,
                        dataT: `${dataT}:slot:${index}`,
                        dataId: slot.placeId,
                        avatarNoPlus: true,
                        iconRight: 'arrowRight'
                    };
                })}
            />
        );
    };

    render() {
        const {isTouch, kiddishSlots, kiddishKnowMoreLink} = this.props;

        return (
            <FamilyLayout mediumMaxWidthOnTouch={true}>
                <div className={b({isTouch})} data-t={dataT}>
                    <h2 className={b('title')}>{i18n('Family.slots-group.title.kiddish')}</h2>

                    <div className={b('description')}>
                        {i18n('Family.kiddish-page.description')}&nbsp;
                        <a
                            href={kiddishKnowMoreLink}
                            className={b('knowMoreLink', {isTouch})}
                            data-t={`${dataT}:know-more-link`}
                        >
                            {i18n('Family.kiddish.know-more-link')}
                        </a>
                    </div>

                    {Boolean(kiddishSlots.length) && this.renderTileList()}
                </div>
            </FamilyLayout>
        );
    }
}

FamilyKiddishLayout.propTypes = {
    isTouch: PropTypes.bool,
    kiddishSlots: PropTypes.array,
    onAddKiddishClick: PropTypes.func,
    onKiddishClick: PropTypes.func,
    kiddishKnowMoreLink: PropTypes.string
};
