import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {ChatWidget} from '@components/ChatWidget';
import {SupportLink} from '@components/SupportLink';
import {FamilyLayout} from '../../components/FamilyLayout';
import {FamilyCardSelector} from '../../components/FamilyCardSelector';
import {FamilySlotsGroup} from '../../components/FamilySlotsGroup';
import {FamilyWebviewHeader} from '../../components/FamilyWebviewHeader';
import {CARDS, SLOTS_GROUP_TYPES} from '../../const';
import './FamilyMainLayout.styl';

const b = cn('FamilyMainLayout');

export const FamilyMainLayout = ({
    slots = [],
    kiddishSlots = [],
    cards = [],
    bottomCards = [],
    contactUsURL,
    chatGuid,
    isTouch,
    isStub,
    isChatExp,
    hideKiddish,
    hideSupport,
    isChildishExp,
    isAm,
    showPlus
}) => {
    const showChatLink = !isStub && !isAm && !hideSupport;
    const showKiddish = !isAm && !hideKiddish && showPlus;
    const showChildish = !isAm && isChildishExp;

    return (
        <FamilyLayout isWhiteBgMobile={true} hideBackButton={true}>
            <div className={b({isTouch, pay: true})} data-t='family:layout:main'>
                {isStub && <h2 className={b('title', {isStub})}>{i18n('Family.main-layout.title.stub')}</h2>}
                {isAm && <FamilyWebviewHeader />}
                {Boolean(cards.length) && (
                    <div className={b('cardsWrap')}>
                        <div className={b('cards', {flexColumn: true})}>
                            {cards.map((card) => (
                                <div
                                    className={b('card', {
                                        empty: !card.type,
                                        small: [CARDS.pay, CARDS.plusSmall, CARDS.loading].includes(card.type),
                                        smallWidth: true
                                    })}
                                    key={card.type}
                                >
                                    <FamilyCardSelector card={card} />
                                </div>
                            ))}
                        </div>
                    </div>
                )}
                {Boolean(slots.length) && (
                    <>
                        {Boolean(slots.length) && (
                            <div className={b('slotsBlock')}>
                                <FamilySlotsGroup slots={slots} type={SLOTS_GROUP_TYPES.MEMBER} />
                            </div>
                        )}
                        {showChildish && (
                            <div className={b('slotsBlock')}>
                                <FamilySlotsGroup slots={kiddishSlots} type={SLOTS_GROUP_TYPES.CHILDISH} />
                            </div>
                        )}
                        {Boolean(kiddishSlots.length) && showKiddish && (
                            <div className={b('slotsBlock')}>
                                <FamilySlotsGroup slots={kiddishSlots} type={SLOTS_GROUP_TYPES.KIDDISH} />
                            </div>
                        )}
                    </>
                )}
                {Boolean(bottomCards.length) && showKiddish && (
                    <div className={b('cards', {bottom: true})}>
                        {bottomCards.map((card) => (
                            <div className={b('card', {empty: !card.type})} key={card.type}>
                                <FamilyCardSelector card={card} />
                            </div>
                        ))}
                    </div>
                )}
                {showChatLink &&
                    (isChatExp ? (
                        <ChatWidget guid={chatGuid} theme='hidden'>
                            {({onClick}) => (
                                <SupportLink blockClassName={b} contactUsURL={contactUsURL} onClick={onClick} />
                            )}
                        </ChatWidget>
                    ) : (
                        <SupportLink blockClassName={b} contactUsURL={contactUsURL} />
                    ))}
            </div>
        </FamilyLayout>
    );
};

FamilyMainLayout.propTypes = {
    slots: PropTypes.array,
    kiddishSlots: PropTypes.array,
    cards: PropTypes.array,
    bottomCards: PropTypes.array,
    familyCapacity: PropTypes.number,
    kiddishCapacity: PropTypes.number,
    contactUsURL: PropTypes.string,
    chatGuid: PropTypes.string,
    isTouch: PropTypes.bool,
    isStub: PropTypes.bool,
    isChatExp: PropTypes.bool,
    isChildishExp: PropTypes.bool,
    hidePayCard: PropTypes.bool,
    hideKiddish: PropTypes.bool,
    hideSupport: PropTypes.bool,
    isAm: PropTypes.bool,
    showPlus: PropTypes.bool
};
