import {connect} from 'react-redux';
import {hasExp} from '@blocks/selectors';
import {FamilyMainLayout as Layout} from './FamilyMainLayout';
import {CONTACT_US_FAMILY_URL} from '../../const';

const mapStateToProps = (state) => {
    const {
        settings: {tld, isTouch} = {},
        subscriptions: {chatGuid} = {},
        family: {familyCapacity, kiddishCapacity, pay = {}, isAdminAccess, hideKiddish, hideSupport} = {},
        am: {isAm} = {},
        dashboard: {plus: {allowed: showPlus = false} = {}} = {}
    } = state;
    const {cardInfo: {bound = false} = {}} = pay;
    const contactUsURL = CONTACT_US_FAMILY_URL.replace('%tld%', tld);
    const isChatExp = hasExp(state, 'plus-subscriptions-chats-on');
    const isChildishExp = hasExp(state, 'profile-family-childish-exp');

    return {
        contactUsURL,
        isChatExp,
        isTouch,
        chatGuid,
        familyCapacity,
        kiddishCapacity,
        bound,
        isAdminAccess,
        isAm,
        isChildishExp,
        hideKiddish,
        hideSupport,
        showPlus
    };
};

export const FamilyMainLayout = connect(mapStateToProps)(Layout);
