import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {FamilyButton} from '../../components/FamilyButton';
import {FamilyLayout} from '../../components/FamilyLayout';
import {PAGE_SELECTOR_TYPES} from '../../const';

import './FamilyMessageLayout.styl';

const b = cn('FamilyMessageLayout');

export const FamilyMessageLayout = ({title, text, curPageSelector, isError, children, buttons}) => (
    <FamilyLayout isCard={curPageSelector !== PAGE_SELECTOR_TYPES.MODAL} hideBackButton={isError}>
        <div className={b({isError})} data-t='family:layout:message'>
            <h2 className={b('title', {withPadding: curPageSelector === PAGE_SELECTOR_TYPES.MODAL})}>{title}</h2>
            <div className={b('text')}>{text}</div>
            {children && <div className={b('children')}>{children}</div>}
            <div className={b('buttons')}>
                {buttons.map((button, index) => (
                    <FamilyButton {...button} key={index} />
                ))}
            </div>
        </div>
    </FamilyLayout>
);

FamilyMessageLayout.propTypes = {
    title: PropTypes.string,
    text: PropTypes.string,
    curPageSelector: PropTypes.string,
    isError: PropTypes.bool,
    children: PropTypes.node,
    buttons: PropTypes.arrayOf(
        PropTypes.shape({
            text: PropTypes.string,
            view: PropTypes.oneOf(['action', 'transparent', 'default']),
            onClick: PropTypes.func
        })
    )
};
