import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {CardsList} from '@components/CardsList';
import {FamilyLayout} from '../../components/FamilyLayout';
import {FamilyButton} from '../../components/FamilyButton';
import {FamilyWarning} from '../../components/FamilyWarning';
import {PAGES, SESSION_STORAGE_KEYS} from '../../const';
import {metrics} from '../../utils/metrics';
import {redirectToRetpathFromWebview} from '@blocks/utils';
import {WEBVIEW_STATUS_SUCCESS, WEBVIEW_STATUS_ERROR} from '@blocks/constants';

import './FamilyPayCardsLayout.styl';

const b = cn('FamilyPayCardsLayout');

export class FamilyPayCardsLayout extends React.Component {
    componentDidMount() {
        this.selectDefaultFamilyCard();
    }
    componentDidUpdate(props) {
        const {cards} = this.props;

        if (props.cards !== cards) {
            this.selectDefaultFamilyCard();
        }
    }
    state = {cardId: null};
    selectDefaultFamilyCard = () => {
        const {cards, cardId} = this.props;

        if (cards.length) {
            const familypayCard = cards.find((card) => card.id === cardId);

            this.selectFamilyCard(familypayCard ? cardId : cards[0].id);
        }
    };
    selectFamilyCard = (cardId) => {
        const {selectCard} = this.props;

        selectCard(cardId);
        this.setState({cardId});
    };
    addNewCard = () => {
        metrics.sendPay(['Выбор карты для семейной оплаты', 'Новая']);
        metrics.goalPay('add_card');
        this.props.goToPage(PAGES.addCard);
    };
    onNextClick = () => {
        metrics.sendPay(['Выбор карты для семейной оплаты', 'Существующая']);
        metrics.goalPay('choose_card');
        this.startBindCard(this.state.cardId);
    };
    startBindCard = (pmId) => {
        const {bindCard, fetchFamily, loading, hasFamily, goToPage, set3dsStatus, retpath, origin} = this.props;

        if (!loading && pmId) {
            bindCard({pmId}, retpath, origin)
                .done(({state = 'challenge', redirectUrl, retpath = ''}) => {
                    const сhaasUrl = state === 'challenge' && redirectUrl;

                    metrics.sendPay(['Потребовался чаас 3дс для создания семейной оплаты', сhaasUrl ? 'Да' : 'Нет']);

                    if (сhaasUrl) {
                        if (sessionStorage && sessionStorage.setItem && !hasFamily) {
                            sessionStorage.setItem(SESSION_STORAGE_KEYS.NO_FAMILY_BEFORE_CHAAS, '1');
                        }

                        window.location.href = сhaasUrl;
                        return;
                    }
                    if (retpath) {
                        return redirectToRetpathFromWebview(retpath, WEBVIEW_STATUS_SUCCESS);
                    }
                    set3dsStatus(true);
                    fetchFamily().done(() => goToPage(PAGES.payAfter3ds));
                })
                .fail(({retpath = ''}) => {
                    if (retpath) {
                        return redirectToRetpathFromWebview(retpath, WEBVIEW_STATUS_ERROR);
                    }
                });
        }
    };
    render() {
        const {cardId} = this.state;
        const {title, text, warningText, loading, hideBackButton} = this.props;

        return (
            <FamilyLayout hideBackButton={hideBackButton}>
                <div className={b({marginTop: !hideBackButton})} data-t='family:layout:pay-cards'>
                    <h2 className={b('title')}>{title}</h2>
                    <div className={b('text')}>{text}</div>
                    <div className={b('content')}>
                        <CardsList
                            setFamilyCard={this.selectFamilyCard}
                            onBindCard={this.addNewCard}
                            disableSelect={loading}
                        />
                    </div>
                    <div className={b('warning')}>
                        <FamilyWarning text={warningText} icon='bell' />
                    </div>
                    <FamilyButton
                        view='action'
                        disabled={!cardId}
                        text={i18n('_AUTH_.next')}
                        onClick={this.onNextClick}
                        dataT='family:layout:pay-cards:next'
                    />
                </div>
            </FamilyLayout>
        );
    }
}

FamilyPayCardsLayout.propTypes = {
    title: PropTypes.string,
    text: PropTypes.string,
    footerText: PropTypes.string,
    cardId: PropTypes.string,
    warningText: PropTypes.string,
    loading: PropTypes.bool,
    hasFamily: PropTypes.bool,
    cardsIsFetched: PropTypes.bool,
    cards: PropTypes.array,
    goToMainPage: PropTypes.func,
    fetchFamily: PropTypes.func,
    bindCard: PropTypes.func,
    set3dsStatus: PropTypes.func,
    goToPage: PropTypes.func.isRequired,
    selectCard: PropTypes.func.isRequired,
    hideBackButton: PropTypes.bool,
    retpath: PropTypes.string,
    origin: PropTypes.string
};
