import {connect} from 'react-redux';
import {selectCard} from '@blocks/morda/cards/actions';
import {set3dsStatus} from '../../middlewares/actions/pay';
import {goToPage, goToMainPage} from '../../middlewares/routing';
import {fetchFamily} from '../../middlewares/api/state';
import {bindCard} from '../../middlewares/api/pay';
import {FamilyPayCardsLayout as PayCardsLayout} from './FamilyPayCardsLayout';

const mapStateToProps = ({
    billing,
    family: {
        loading = false,
        hidePayCardsPageBackButton = false,
        isPayCardsPage = false,
        hasFamily = false,
        origin = '',
        pay: {cardInfo: {cardId} = {}} = {}
    } = {},
    common: {retpath} = {}
}) => {
    const {cards = []} = billing || {};

    return {
        cardId,
        cards,
        loading,
        hasFamily,
        cardsIsFetched: Boolean((billing || {}).cards),
        hideBackButton: isPayCardsPage && hidePayCardsPageBackButton,
        retpath,
        origin
    };
};

const mapDispatchToProps = {bindCard, goToMainPage, goToPage, fetchFamily, set3dsStatus, selectCard};

export const FamilyPayCardsLayout = connect(mapStateToProps, mapDispatchToProps)(PayCardsLayout);
