import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {FamilyLayout} from '../../components/FamilyLayout';
import {FamilyAvatar} from '../../components/FamilyAvatar';
import {FamilyButton} from '../../components/FamilyButton';
import {FamilyUniversalTileList} from '../../components/FamilyUniversalTileList';
import './FamilySlotInfoLayout.styl';

const b = cn('FamilySlotInfoLayout');

export const FamilySlotInfoLayout = ({
    isTouch,
    isBigMargins,
    children,
    tiles,
    buttons,
    title,
    subtitle,
    description
}) => {
    return (
        <FamilyLayout hideBackButton={true}>
            <div className={b({isTouch})} data-t='family:layout:slot-info'>
                <div className={b('avatar')}>
                    <FamilyAvatar isCentered={true} isCurrentSlot={true} size='l' />
                </div>
                <div className={b('titleBlock', {isBigMargins})}>
                    <div className={b('title')}>{title}</div>
                    {Boolean(subtitle) && <div className={b('subtitle')}>{subtitle}</div>}
                    {Boolean(description) && <div className={b('description')}>{description}</div>}
                </div>
                {Boolean(children) && <div className={b('content')}>{children}</div>}
                {Boolean(tiles.length) && (
                    <div className={b('controls')}>
                        <FamilyUniversalTileList tiles={tiles} />
                    </div>
                )}
                {Boolean(buttons.length) && (
                    <div className={b('buttons')}>
                        {buttons.map((button, index) => button && <FamilyButton {...button} key={index} />)}
                    </div>
                )}
            </div>
        </FamilyLayout>
    );
};

FamilySlotInfoLayout.propTypes = {
    isTouch: PropTypes.bool,
    bound: PropTypes.bool,
    isBigMargins: PropTypes.bool,
    children: PropTypes.node,
    title: PropTypes.string,
    subtitle: PropTypes.string,
    description: PropTypes.string,
    tiles: PropTypes.array,
    currentSlot: PropTypes.object,
    buttons: PropTypes.arrayOf(
        PropTypes.shape({
            text: PropTypes.string,
            view: PropTypes.oneOf(['action', 'transparent', 'default']),
            onClick: PropTypes.func
        })
    )
};
