import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {FamilyLayout} from '../../components/FamilyLayout';
import {FamilyButton} from '../../components/FamilyButton';
import {FamilyUniversalTileList} from '../../components/FamilyUniversalTileList';
import './FamilyTilesListLayout.styl';

const b = cn('FamilyTilesListLayout');

export const FamilyTilesListLayout = ({isTouch, title, goBack, tilesLists, buttons}) => {
    return (
        <FamilyLayout onBackButtonClick={goBack}>
            <div className={b({isTouch})} data-t='family:layout:tiles-list'>
                <div className={b('title')}>{title}</div>
                {Boolean(tilesLists.length) &&
                    tilesLists.map((tiles, i) => (
                        <div className={b('controls')} key={i}>
                            <FamilyUniversalTileList tiles={tiles} />
                        </div>
                    ))}
                {Boolean(buttons.length) && (
                    <div className={b('buttons')}>
                        {buttons.map((button, index) => button && <FamilyButton {...button} key={index} />)}
                    </div>
                )}
            </div>
        </FamilyLayout>
    );
};

FamilyTilesListLayout.propTypes = {
    isTouch: PropTypes.bool,
    title: PropTypes.string,
    goBack: PropTypes.func,
    tilesLists: PropTypes.array,
    buttons: PropTypes.arrayOf(
        PropTypes.shape({
            text: PropTypes.string,
            view: PropTypes.oneOf(['action', 'transparent', 'default']),
            onClick: PropTypes.func
        })
    )
};
