import {metrics} from '../../utils/metrics';
import * as actions from '../../actions';
import {makeRequest} from './utils';

export const fetchInvite = (inviteId) => (dispatch) =>
    makeRequest(dispatch, '/profile/family/invite/state', {inviteId}).done(({admin}) =>
        dispatch(actions.setFamilyCurrentSlot(admin))
    );

export const postInviteConfirm = (inviteId) => (dispatch) => {
    return makeRequest(dispatch, '/profile/family/invite/accept', {inviteId}).done(() => {
        metrics.goal('add_member_confirm');

        dispatch(actions.setFamilyInviteConfirmed());
    });
};

export const postInvite = (contact) => (dispatch) => {
    if (contact) {
        dispatch(actions.setInviteContact(contact));
    }
    return makeRequest(dispatch, '/profile/family/invite/create', {contact}).done(
        ({inviteId, inviteContact, inviteMethod}) => {
            dispatch(actions.setFamilyInviteId(inviteId));
            dispatch(actions.addFamilyInvite({inviteId, inviteContact, inviteMethod}));
        }
    );
};

export const requestCancelInvite = (inviteId) => (dispatch) => {
    metrics.send(['Запрос на удаление инвайта']);
    return makeRequest(dispatch, '/profile/family/invite/cancel', {inviteId}).done(() => {
        dispatch(actions.removeFamilyInvite(inviteId));
    });
};
