import {addFamilyKiddish, removeFamilyKiddish, changeFamilySlot} from '../../actions';
import {makeRequest} from './utils';

export const postKiddish = () => (dispatch, getState) => {
    const {family: {currentSlot = {}} = {}} = getState();

    return makeRequest(dispatch, '/profile/family/kiddish/create', currentSlot).done(() =>
        dispatch(addFamilyKiddish({...currentSlot, isKiddish: true, isEmpty: false}))
    );
};

export const postRemoveKiddish = (uid) => (dispatch) =>
    makeRequest(dispatch, '/profile/family/kiddish/remove', {uid}).done(() => dispatch(removeFamilyKiddish(uid)));

export const postEditKiddish = () => (dispatch, getState) => {
    const {family: {currentSlot = {}} = {}} = getState();

    return makeRequest(dispatch, '/profile/family/kiddish/edit', currentSlot).done(() =>
        dispatch(changeFamilySlot({placeId: currentSlot.placeId, slot: currentSlot}))
    );
};
